<!doctype html>
<html lang="en">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<!-- Custom Files -->
<link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
<link rel="stylesheet" type="text/css" href="assets/css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"/>
<link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">

    <meta name="ip2loc" content="2400:adc1:4ac:3300:7884:68ef:c6f0:ccee">
    <title>Terms of Service | Amzn Prime Publications</title>
    <meta name="keywords" content="8 hours publishing, Amzn Prime Publications, Book Publication">
    <meta name="description" content="Every book publishing agreement has a grant of rights clause. Subsidiary rights include the rights to make adaptions of the book – Amzn Prime Publications.">
</head>

<body>
<?php include 'include/header.php'?>
    <section class="banner main-banner inner-banner privacy text-center"> 
        <div class="container-fluid px-md-5" data-aos="fade-up" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-12" data-aos="fade-left" data-aos-duration="1100">
                    <div class="inner-pic">
                        <h1 class="text-white">Terms of <span class="primary-color d-inline-block">Service</span></h1>
                        <p class="text-white py-3">
                            Welcome to Amzn Prime Publications. By accessing our website or using our services, you agree <br>
                            to be bound by these Terms of Service (ToS). Please read them carefully.
                        </p>
                        <a href="tel:+15043538316" class="btn btn-red px-md-4">Request A Call Back <i class="fas fa-phone right-icon"></i></a>
                        <a href="javascript:" id="chat_toggle" class="btn btn-blue" >Live Chat <i class="fas fa-comments"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="book1 terms">
        <div class="container" data-aos="fade-down" data-aos-duration="1000">
            <h2 class="text-center">Terms of Service</h2>
            <div class="row align-items-center">
                <div class="col-md-12">
                    <h3>1. Overview</h3>
                    <p class="font-weight-normal">
                        By subscribing to our SMS and email communication services, you agree to receive text messages
                        and emails from Amzn Prime Publications. These communications may include updates, promotional
                        content, notifications, and other information related to our services. Your participation in
                        these programs is subject to the following Terms of Service, in compliance with 10DLC TCR
                        regulations for the US and Canada.
                    </p>
                    <h3>2. Opt-In Process</h3>
                    <p>SMS Subscription: When you provide your mobile number on our website, you may receive a
                        confirmation text message asking for your consent to subscribe to our SMS service. By replying
                        to the confirmation message with the designated keyword (e.g., "YES"), you agree to opt in to
                        receive SMS messages from Amzn Prime Publications.
                        <br>
                        Email Subscription: By providing your email address and selecting the option to receive
                        communications from us, you consent to receiving emails related to our services, promotions, and
                        updates.
                    </p>
                    <h3>3. Message Frequency</h3>
                    <p>SMS: The number of SMS messages you receive may vary based on your communication requirements
                        with our team. This allows us to provide timely updates and respond to your needs effectively.
                        <br>
                        Email: Emails will be sent periodically and may vary in frequency depending on the type of
                        communication and your preferences.
                    </p>
                    <h3>4. Opt-Out Process</h3>
                    <p>
                        SMS Opt-Out: You can opt out of our SMS communications at any time by replying to any of our
                        messages with the word "STOP". Upon receipt of your opt-out request, we will send a confirmation
                        message, and you will no longer receive SMS messages from us.
                        <br>
                        Email Opt-Out: To unsubscribe from our email communications, click the "unsubscribe" link
                        provided at the bottom of any email we send. You can also contact us directly at <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a>
                        to request removal from our email list.
                    </p>
                    <h3>5. Cost</h3>
                    <p>SMS: Message and data rates may apply based on your mobile carrier plan. Please check with your
                        carrier for details. <br>
                        Email: There is no charge for email communications.
                    </p>
                    <h3>6. Privacy Policy</h3>
                    <p>Your privacy is important to us. Please review our Privacy Policy for detailed information on how
                        we collect, use, and protect your personal information.
                    </p>
                    <h3>7. Support</h3>
                    <p>If you have any questions or need assistance with our SMS or email services, please contact our
                        support team at <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a> or call us at <a href="tel:+15043538316">(504) 353-8316</a>.</p>
                    <h3>8. Modifications</h3>
                    <p>We reserve the right to modify these Terms of Service at any time. Changes will be effective
                        immediately upon posting to our website. Continued use of our SMS and email services after any
                        changes indicates your acceptance of the new terms.</p>
                    <h3>9. Compliance</h3>
                    <p>We adhere to the rules and regulations set forth by the 10DLC TCR (The Campaign Registry) and
                        comply with all relevant laws and guidelines for SMS and email marketing in the US and Canada.
                        <br>
                        Your participation in our messaging programs is subject to these regulations.
                    </p>
                    <h2>SMS and Email Terms of Service</h2>
                    <h3>1. Overview</h3>
                    <p>By subscribing to our SMS and email communication services, you agree to receive text messages and emails from Amzn Prime Publications. These communications may include updates, promotional content, notifications, and other information related to our services. Your participation in these programs is subject to the following Terms of Service, in compliance with 10DLC TCR regulations for the US and Canada.</p>
                    <h3>2. Opt-In Process</h3>
                    <p>SMS Subscription: When you provide your mobile number on our website, you may receive a confirmation text message asking for your consent to subscribe to our SMS service. By replying to the confirmation message with the designated keyword (e.g., "YES"), you agree to opt in to receive SMS messages from Amzn Prime Publications. Email Subscription: By providing your email address and selecting the option to receive communications from us, you consent to receiving emails related to our services, promotions, and updates.</p>
                    <h3>3. Message Frequency</h3>
                    <p>SMS: The number of SMS messages you receive may vary based on your communication requirements with our team. This allows us to provide timely updates and respond to your needs effectively.
                        Email: Emails will be sent periodically and may vary in frequency depending on the type of communication and your preferences.</p>
                    <h3>4. Opt-Out Process</h3>
                    <p>SMS Opt-Out: You can opt out of our SMS communications at any time by replying to any of our messages with the word "STOP". Upon receipt of your opt-out request, we will send a confirmation message, and you will no longer receive SMS messages from us.
                        Email Opt-Out: To unsubscribe from our email communications, click the "unsubscribe" link provided at the bottom of any email we send. You can also contact us directly at <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a> to request removal from our email list.</p>
                    <h3>5. Cost</h3>
                    <p>SMS: Message and data rates may apply based on your mobile carrier plan. Please check with your carrier for details.
                        Email: There is no charge for email communications.</p>
                    <h3>6. Privacy Policy</h3>
                    <p>Your privacy is important to us. Please review our Privacy Policy for detailed information on how we collect, use, and protect your personal information.</p>
                    <h3>7. Support</h3>
                    <p>If you have any questions or need assistance with our SMS or email services, please contact our support team at <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a> or call us at (504) 353-8316.</p>
                    <h3>8. Modifications</h3>
                    <p>We reserve the right to modify these Terms of Service at any time. Changes will be effective immediately upon posting to our website. Continued use of our SMS and email services after any changes indicates your acceptance of the new terms.</p>
                    <h3>9. Compliance</h3>
                    <p>We adhere to the rules and regulations set forth by the 10DLC TCR (The Campaign Registry) and comply with all relevant laws and guidelines for SMS and email marketing in the US and Canada. Your participation in our messaging programs is subject to these regulations.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="bottom-form">
    <div class="container" data-aos="zoom-in" data-aos-duration="1200">
        <div class="row">
            <div class="col-md-12">
                <div class="get-started-form main-form">
                    <form action="https://amznprimepublications.com/mail.php" method="post" class="validate-bottom-form form-get-quote">
                        <h6 class="text-white text-center">Feel Free to request now</h6>
                        <h2 class="text-center text-white pb-3">Make an Appointment</h2>
                        <input type="text" class="required input-control form-control" name="quote[name]" required id="name" placeholder="Full Name" />
                        <input type="email" class="required input-control form-control email" id="emailTwo" required name="quote[email]" placeholder="Email">
                        <input type="tel" class="required input-control form-control" name="quote[phone]" required placeholder="Phone Number">
                        <select name="quote[services]" id="ser-select" class="required input-control form-control d-inline-block">
                            <option selected>Select Services</option>
                            <option value="Digital Book Publishing">Digital Book Publishing</option>
                            <option value="Book Marketing Service">Book Marketing Service</option>
                            <option value="Ghostwriting Service">Ghostwriting Service</option>
                            <option value="Fiction Writing Service">Fiction Writing Service</option>
                            <option value="Children’s Books Service">Children’s Books Service</option>
                            <option value="Book Editing & Proofreading Service">Book Editing & Proofreading Service</option>
                            <option value="Book Cover Designing">Book Cover Designing</option>
                            <option value="Illustrations & Graphics Service">Illustrations & Graphics Service</option>
                            <option value="Book Printing Service">Book Printing Service</option>
                            <option value="Audiobook Production">Audiobook Production</option>
                            <option value="Author Website Service">Author Website Service</option>
                            <option value="Blurb Writing Service">Blurb Writing Service</option>
                            <option value="Amazon Book Description">Amazon Book Description</option>
                            <option value="Amazon Book Listing Optimization">Amazon Book Listing Optimization</option>
                            <option value="Amazon Book Paid Ads">Amazon Book Paid Ads</option>
                            <option value="Amazon Central Account">Amazon Central Account</option>
                            <option value="Amazon A + Content">Amazon A + Content</option>
                            <option value="Book Trailer">Book Trailer</option>
                            <option value="Featured Articles">Featured Articles</option>
                        </select>
                        <textarea class="required input-control form-control" autocomplete="nope" name="quote[comments]" placeholder="About Project"></textarea>
                        <div class="pt-3 text-center">
                            <label class="chota_fnt d-inline-block"><input type="checkbox" name="bn_emailPromotional" required="" checked>
                                Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                                <a href="privacy-policy.php">PRIVACY POLICY </a>
                                & <a href="terms-of-service.php">TERMS OF SERVICE</a> )
                                - Carrier charges may apply for SMS. Reply STOP or UNSUBSCRIBE to STOP to unsubscribe anytime.
                            </label>
                        </div>
                        <input type="hidden" name="pageurl" value="terms-of-service.php">
                        <input type="hidden" name="ip2loc_ip" value="" />
                        <input type="hidden" name="ip2loc_isp" value="" />
                        <input type="hidden" name="ip2loc_org" value="" />
                        <input type="hidden" name="ip2loc_country" value="" />
                        <input type="hidden" name="ip2loc_region" value="" />
                        <input type="hidden" name="ip2loc_city" value="" />
                        <div class="text-center">
                            <input type="submit" id="register" class="btn btn-red" name="send_data" value="Let's Get Started" onclick="abc()"> <br />
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'include/footer.php'?>

<a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

<div class="popupform modal" id="popupform">
    <div class="modal-content">
        <div class="modal-body p-0">
            <button class="close-popup"><i class="fa-solid fa-xmark"></i></button>
            <div class="popup-bann">
                <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp" alt="">
            </div>
            <div class="popup-content">
                <h2>
                    SIGNUP NOW TO AVAIL
                    Get Your <span class="d-block primary-color"> THE 40% DISCOUNT OFFER </span>
                    GET A FREE CONSULTATION CALL
                </h2>
                <form action="https://amznprimepublications.com/mail.php" method="post" class="form-get-quote validate-popup-form">
                    <div class="row p-3">
                        <input type="text" class="required form-control" name="quote[name]" required="" id="name" placeholder="Full Name" aria-required="true">
                        <input type="email" class="required form-control email" id="email" required name="quote[email]" placeholder="Email">
                        <input type="tel" class="required form-control" required name="quote[phone]" placeholder="Phone Number">
                        <textarea class="required form-control" autocomplete="nope" name="quote[comments]" required placeholder="I am looking for..." placeholder="Breif discuss about your book..."></textarea>
                        <div class="col-md-12 pt-md-4 text-center">
                            <input type="submit" class="btn btn-red" name="send_data" value="Submit now">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop" id="modalBackdrop"></div>
<script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
<script type="text/javascript" src="assets/js/libs.js"></script>
<script type="text/javascript" src="assets/js/functions.js"></script>

<?php include 'include/chat.php'?>
<?php include 'include/ip.php'?>

</body>

</html>
