<!doctype html>
<html lang="en">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<!-- Custom Files -->
<link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
<link rel="stylesheet" type="text/css" href="assets/css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"/>
<link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">

    <meta name="ip2loc" content="2400:adc1:4ac:3300:7884:68ef:c6f0:ccee">
    <title>Privacy Policy | Amzn Prime Publications</title>
    <meta name="keywords" content="Privacy Policy, Amzn Prime Publications, Data Protection, Book Publishing">
    <meta name="description" content="Privacy Policy for Amzn Prime Publications. Learn how we collect, use, disclose, and protect your personal information, including SMS and email communications.">
</head>

<body>
<?php include 'include/header.php'?>
    <section class="banner main-banner inner-banner privacy text-center"> 
        <div class="container-fluid px-md-5" data-aos="fade-up" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-12" data-aos="fade-left" data-aos-duration="1100">
                    <div class="inner-pic">
                        <h1 class="text-white">Privacy <span class="primary-color d-inline-block">Policy</span></h1>
                        <p class="text-white py-3">
                            Your privacy matters. This policy explains what data we collect, how we use it, and the choices you have.
                        </p>
                        <a href="tel:+15043538316" class="btn btn-red px-md-4">Request A Call Back <i class="fas fa-phone right-icon"></i></a>
                        <a href="javascript:" id="chat_toggle" class="btn btn-blue">Live Chat <i class="fas fa-comments"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="book1 terms">
        <div class="container" data-aos="fade-down" data-aos-duration="1000">
            <h2 class="text-center">Privacy Policy</h2>
            <p class="text-center mb-5"><strong>Effective Date:</strong> September 5, 2025</p>
            <div class="row align-items-start">
                <div class="col-md-12">

                    <h3>1. Who We Are</h3>
                    <p>
                        This Privacy Policy describes how <strong>Amzn Prime Publications</strong> (“we,” “us,” or “our”) collects, uses,
                        discloses, and protects your information when you visit our website, interact with our forms, subscribe to communications,
                        or use our services. If you have any questions, contact us at
                        <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a> or <a href="tel:+15043538316">(504) 353-8316</a>.
                    </p>

                    <h3>2. Information We Collect</h3>
                    <ul>
                        <li><strong>Information You Provide:</strong> Name, email, phone number, service preferences, project details, and any files or messages you submit through forms or chat.</li>
                        <li><strong>Transactional & Account Data:</strong> Service selections, consultation notes, invoices/receipts (where applicable).</li>
                        <li><strong>Communications Data:</strong> Your consent preferences (SMS/email), message history with our team.</li>
                        <li><strong>Device/Usage Data:</strong> IP address, browser type, device identifiers, pages viewed, referring URLs, time spent, and clickstream data.</li>
                        <li><strong>Cookies & Similar Technologies:</strong> See “Cookies & Tracking” below.</li>
                        <li><strong>Approximate Location:</strong> Based on IP, solely for security, fraud prevention, and localization (e.g., time zone).</li>
                    </ul>

                    <h3>3. How We Use Your Information</h3>
                    <ul>
                        <li>To provide, operate, and improve our website and services.</li>
                        <li>To respond to inquiries, schedule calls, and deliver requested services.</li>
                        <li>To send service updates, transactional notices, and—with your consent—marketing messages via SMS or email.</li>
                        <li>To personalize content, analyze performance, and enhance user experience.</li>
                        <li>To protect against fraud, abuse, or misuse and to maintain the security of our systems.</li>
                        <li>To comply with legal obligations and enforce our <a href="terms-of-service.php">Terms of Service</a>.</li>
                    </ul>

                    <h3>4. Legal Bases (GDPR/UK GDPR)</h3>
                    <p>Where the EU/UK data protection laws apply, we process data under these legal bases:</p>
                    <ul>
                        <li><strong>Contractual Necessity:</strong> To deliver services you request.</li>
                        <li><strong>Consent:</strong> For optional marketing (SMS/email), cookies, and certain analytics.</li>
                        <li><strong>Legitimate Interests:</strong> Website functionality, service improvement, and security (balanced with your rights).</li>
                        <li><strong>Legal Obligation:</strong> Compliance, record-keeping, and responding to lawful requests.</li>
                    </ul>

                    <h3>5. SMS & Email Communications (10DLC/TCR Compliance)</h3>
                    <ul>
                        <li><strong>Opt-In:</strong> By providing your phone/email and selecting to receive communications, you consent to SMS/email from us. For SMS, you may be asked to reply with a keyword (e.g., “YES”) to confirm.</li>
                        <li><strong>Message Frequency:</strong> Varies based on your interactions and service needs.</li>
                        <li><strong>Opt-Out:</strong> Reply <strong>STOP</strong> to any SMS to unsubscribe. For email, click “unsubscribe” in any message or email <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a>.</li>
                        <li><strong>Costs:</strong> Standard carrier message/data rates may apply for SMS.</li>
                        <li><strong>Program Rules:</strong> We adhere to The Campaign Registry (TCR) 10DLC requirements for US/Canada messaging programs.</li>
                    </ul>

                    <h3>6. Cookies & Tracking Technologies</h3>
                    <p>
                        We use cookies and similar technologies to operate our site, remember preferences, analyze traffic, and measure marketing performance.
                        You can adjust your browser settings to refuse some or all cookies. Disabling cookies may affect site functionality.
                    </p>

                    <h3>7. Analytics & Third-Party Tools</h3>
                    <p>
                        We may use analytics or performance tools (e.g., aggregated statistics, heatmaps) to understand site usage and improve services.
                        These providers may set their own cookies and process pseudonymous usage data on our behalf. We do not sell personal information.
                    </p>

                    <h3>8. How We Share Information</h3>
                    <ul>
                        <li><strong>Service Providers:</strong> Web hosting, analytics, email/SMS delivery, form processing, payment/invoicing (if used). They process data under our instructions.</li>
                        <li><strong>Business Transfers:</strong> In a merger, acquisition, or asset sale, your data may be transferred as permitted by law.</li>
                        <li><strong>Legal & Safety:</strong> To comply with law, enforce our terms, or protect rights, property, users, or the public.</li>
                    </ul>

                    <h3>9. Data Retention</h3>
                    <p>
                        We retain personal data only as long as necessary for the purposes described in this Policy—typically for the duration of
                        services and a reasonable period thereafter for records, accounting, legal compliance, and dispute resolution.
                    </p>

                    <h3>10. Security</h3>
                    <p>
                        We implement administrative, technical, and physical safeguards designed to protect personal data.
                        No method of transmission or storage is 100% secure; we cannot guarantee absolute security.
                    </p>

                    <h3>11. International Data Transfers</h3>
                    <p>
                        If you access our site from outside the country where our servers or providers are located, your information may be transferred
                        to and processed in jurisdictions with different data protection laws. Where required, we use appropriate safeguards (e.g., SCCs).
                    </p>

                    <h3>12. Your Rights & Choices</h3>
                    <p>Your rights depend on your location and applicable law. Subject to limits, you may have the right to:</p>
                    <ul>
                        <li>Access, correct, or delete your personal information.</li>
                        <li>Object to or restrict certain processing, or withdraw consent at any time (without affecting prior lawful processing).</li>
                        <li>Data portability (receive a copy of your data in a usable format).</li>
                        <li>Opt-out of marketing communications (SMS STOP / email unsubscribe).</li>
                        <li>Manage cookies via browser or device settings.</li>
                    </ul>
                    <p>To exercise rights, contact: <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a>.</p>

                    <h3>13. CCPA/CPRA (California)</h3>
                    <p>
                        California residents have the right to know, access, correct, delete, and opt out of certain data sharing as defined by law.
                        We do not “sell” personal information as defined by the CCPA/CPRA. We may “share” for cross-context behavioral advertising only
                        if you consent via cookies; you can opt out by adjusting cookie settings. We will not discriminate against you for exercising your rights.
                    </p>

                    <h3>14. Children’s Privacy</h3>
                    <p>
                        Our services are not directed to children under 13 (or relevant local age of digital consent). We do not knowingly collect personal
                        information from children. If you believe a child has provided personal data, please contact us to request deletion.
                    </p>

                    <h3>15. Do Not Track</h3>
                    <p>
                        Some browsers offer “Do Not Track” (DNT) signals. Because there is no common industry standard, our site may not respond to DNT.
                        You can manage tracking via cookie settings and browser controls.
                    </p>

                    <h3>16. Links to Other Websites</h3>
                    <p>
                        Our site may contain links to third-party websites. We are not responsible for their privacy practices. Review their policies before providing data.
                    </p>

                    <h3>17. Changes to This Policy</h3>
                    <p>
                        We may update this Privacy Policy from time to time. Changes take effect upon posting on this page with an updated effective date.
                        Material changes will be highlighted or communicated when appropriate. Your continued use of our site/services means you accept the updated Policy.
                    </p>

                    <h3>18. Contact Us</h3>
                    <p>
                        For questions, requests, or complaints:
                        <br>Email: <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a>
                        <br>Phone: <a href="tel:+15043538316">(504) 353-8316</a>
                    </p>

                </div>
            </div>
        </div>
    </section>

    <section class="bottom-form">
        <div class="container" data-aos="zoom-in" data-aos-duration="1200">
            <div class="row">
                <div class="col-md-12">
                    <div class="get-started-form main-form">
                        <form action="https://amznprimepublications.com/mail.php" method="post" class="validate-bottom-form form-get-quote">
                            <h6 class="text-white text-center">Feel Free to request now</h6>
                            <h2 class="text-center text-white pb-3">Make an Appointment</h2>
                            <input type="text" class="required input-control form-control" name="quote[name]" required id="name" placeholder="Full Name" />
                            <input type="email" class="required input-control form-control email" id="emailTwo" required name="quote[email]" placeholder="Email">
                            <input type="tel" class="required input-control form-control" name="quote[phone]" required placeholder="Phone Number">
                            <select name="quote[services]" id="ser-select" class="required input-control form-control d-inline-block">
                                <option selected>Select Services</option>
                                <option value="Digital Book Publishing">Digital Book Publishing</option>
                                <option value="Book Marketing Service">Book Marketing Service</option>
                                <option value="Ghostwriting Service">Ghostwriting Service</option>
                                <option value="Fiction Writing Service">Fiction Writing Service</option>
                                <option value="Children’s Books Service">Children’s Books Service</option>
                                <option value="Book Editing & Proofreading Service">Book Editing & Proofreading Service</option>
                                <option value="Book Cover Designing">Book Cover Designing</option>
                                <option value="Illustrations & Graphics Service">Illustrations & Graphics Service</option>
                                <option value="Book Printing Service">Book Printing Service</option>
                                <option value="Audiobook Production">Audiobook Production</option>
                                <option value="Author Website Service">Author Website Service</option>
                                <option value="Blurb Writing Service">Blurb Writing Service</option>
                                <option value="Amazon Book Description">Amazon Book Description</option>
                                <option value="Amazon Book Listing Optimization">Amazon Book Listing Optimization</option>
                                <option value="Amazon Book Paid Ads">Amazon Book Paid Ads</option>
                                <option value="Amazon Central Account">Amazon Central Account</option>
                                <option value="Amazon A + Content">Amazon A + Content</option>
                                <option value="Book Trailer">Book Trailer</option>
                                <option value="Featured Articles">Featured Articles</option>
                            </select>
                            <textarea class="required input-control form-control" autocomplete="nope" name="quote[comments]" placeholder="About Project"></textarea>
                            <div class="pt-3 text-center">
                                <label class="chota_fnt d-inline-block"><input type="checkbox" name="bn_emailPromotional" required checked>
                                    Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                                    <a href="privacy-policy.php">PRIVACY POLICY</a>
                                    & <a href="terms-of-service.php">TERMS OF SERVICE</a> )
                                    - Carrier charges may apply for SMS. Reply STOP or UNSUBSCRIBE to STOP to unsubscribe anytime.
                                </label>
                            </div>
                            <input type="hidden" name="pageurl" value="privacy-policy.php">
                            <input type="hidden" name="ip2loc_ip" value="" />
                            <input type="hidden" name="ip2loc_isp" value="" />
                            <input type="hidden" name="ip2loc_org" value="" />
                            <input type="hidden" name="ip2loc_country" value="" />
                            <input type="hidden" name="ip2loc_region" value="" />
                            <input type="hidden" name="ip2loc_city" value="" />
                            <div class="text-center">
                                <input type="submit" id="register" class="btn btn-red" name="send_data" value="Let's Get Started" onclick="abc()"> <br />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php include 'include/footer.php'?>

<a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

<div class="popupform modal" id="popupform">
    <div class="modal-content">
        <div class="modal-body p-0">
            <button class="close-popup"><i class="fa-solid fa-xmark"></i></button>
            <div class="popup-bann">
                <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp" alt="">
            </div>
            <div class="popup-content">
                <h2>
                    SIGNUP NOW TO AVAIL
                    Get Your <span class="d-block primary-color"> THE 40% DISCOUNT OFFER </span>
                    GET A FREE CONSULTATION CALL
                </h2>
                <form action="https://amznprimepublications.com/mail.php" method="post" class="form-get-quote validate-popup-form">
                    <div class="row p-3">
                        <input type="text" class="required form-control" name="quote[name]" required id="name" placeholder="Full Name" aria-required="true">
                        <input type="email" class="required form-control email" id="email" required name="quote[email]" placeholder="Email">
                        <input type="tel" class="required form-control" required name="quote[phone]" placeholder="Phone Number">
                        <textarea class="required form-control" autocomplete="nope" name="quote[comments]" required placeholder="I am looking for..." placeholder="Briefly discuss your book..."></textarea>
                        <div class="col-md-12 pt-md-4 text-center">
                            <input type="submit" class="btn btn-red" name="send_data" value="Submit now">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop" id="modalBackdrop"></div>

<script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
<script type="text/javascript" src="assets/js/libs.js"></script>
<script type="text/javascript" src="assets/js/functions.js"></script>

<?php include 'include/chat.php'?>
<?php include 'include/ip.php'?>

</body>

<!-- Mirrored from amznprimepublications.com/privacy-policy.php by HTTrack Website Copier/3.x [XR&CO'2014], Thu, 01 May 2025 01:24:24 GMT -->
</html>
