<?php
// === CONFIG ===
$to = "support@amznprimepublications.com"; // Change to your business email
$brandname = "Amzn Prime Publications ";
$redirecturl = "Location: https://amznprimepublications.com/thank-you.php";

// === SANITIZATION FUNCTION ===
function sanitize($input) {
    return htmlspecialchars(trim($input));
}

// === EXTRACTING QUOTE FORM DATA ===
$quote = $_POST['quote'] ?? [];
$name = sanitize($quote['name'] ?? $_POST['name'] ?? $_POST['n'] ?? "Not provided");
$email = sanitize($quote['email'] ?? $_POST['email'] ?? $_POST['e'] ?? "Not provided");
$phone = sanitize($quote['phone'] ?? $_POST['phone'] ?? $_POST['p'] ?? "Not provided");
$msg = sanitize($quote['comments'] ?? $_POST['msg'] ?? $_POST['m'] ?? "Not provided");

// === OPTIONAL FIELDS ===
$service = sanitize($_POST['service'] ?? $_POST['s'] ?? "Not provided");
$package = sanitize($_POST['package'] ?? $_POST['pa'] ?? "Not provided");
$interest = sanitize($_POST['interest'] ?? $_POST['i'] ?? "Not provided");
$formtype = sanitize($_POST['ftype'] ?? "Form filled by user");

// === GEOLOCATION & PAGE URL ===
$ip = sanitize($_POST['ip2loc_ip'] ?? "Not provided");
$country = sanitize($_POST['ip2loc_country'] ?? "Not provided");
$region = sanitize($_POST['ip2loc_region'] ?? "Not provided");
$city = sanitize($_POST['ip2loc_city'] ?? "Not provided");
$pageurl = sanitize($_POST['pageurl'] ?? "Not provided");

// === EMAIL SUBJECT & HEADERS ===
$subject = "Lead Alert: $brandname - $name at " . date("Y-m-d H:i:s");

$headers = "From: leads@amznprimepublications.com\r\n";
$headers .= "Reply-To: $email\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-type: text/html; charset=UTF-8\r\n";
$headers .= "Message-ID: <" . md5(uniqid(time())) . "@".$_SERVER['SERVER_NAME'].">\r\n";

// === MESSAGE BODY ===
$message = "
<h3>New Lead Details</h3>
<p><strong>Name:</strong> $name</p>
<p><strong>Email:</strong> $email</p>
<p><strong>Phone:</strong> $phone</p>
<p><strong>Message:</strong> $msg</p>
<p><strong>Package:</strong> $package</p>
<p><strong>Interest:</strong> $interest</p>
<p><strong>Services:</strong> $service</p>
<p><strong>IP Address:</strong> $ip</p>
<p><strong>Country:</strong> $country</p>
<p><strong>Region:</strong> $region</p>
<p><strong>City:</strong> $city</p>
<p><strong>Page URL:</strong> $pageurl</p>
";


// === SAVE TO CSV ===
$csvFile = __DIR__ . "/leads.csv"; // saves in current directory
$row = [
    'timestamp' => date('c'),
    'name'      => $name,
    'email'     => $email,
    'phone'     => $phone,
    'message'   => $msg,
    'package'   => $package,
    'interest'  => $interest,
    'service'   => $service,
    'ip'        => $ip,
    'country'   => $country,
    'region'    => $region,
    'city'      => $city,
    'pageurl'   => $pageurl,
    'formtype'  => $formtype
];
$writeHeader = !file_exists($csvFile);
if ($fp = fopen($csvFile, 'a')) {
    if ($writeHeader) {
        fputcsv($fp, array_keys($row));
    }
    fputcsv($fp, array_values($row));
    fclose($fp);
}



// === SEND MAIL ===
if (mail($to, $subject, $message, $headers)) {
    header("$redirecturl?name=$name&phone=$phone&email=$email");
} else {
    header("$redirecturl?error=1");
}
exit;
?>