<?php

file_put_contents("debug_log.txt", print_r($_POST, true));

// === CONFIG ===
$to = "support@amznprimepublications.com";
$brandname = "Amzn Prime Publications";
$redirecturl = "Location: https://amznprimepublications.com/lp/thankyou.php";
$csv_file = 'form_submissions.csv'; // CSV file where data will be stored

// === SANITIZATION FUNCTION ===
function sanitize($input) {
    return htmlspecialchars(trim($input));
}

// === BUILD MESSAGE FROM ALL POSTED FIELDS ===
$message = "<h3>New Lead Details from $brandname</h3>";

foreach ($_POST as $key => $value) {
    $clean_key = sanitize($key);
    $clean_value = is_array($value) ? implode(', ', array_map('sanitize', $value)) : sanitize($value);
    $message .= "<p><strong>" . ucfirst($clean_key) . ":</strong> " . nl2br($clean_value) . "</p>";
}

// === SAVE TO CSV ===
$csv_data = [];
foreach ($_POST as $key => $value) {
    $clean_key = sanitize($key);
    $clean_value = is_array($value) ? implode(', ', array_map('sanitize', $value)) : sanitize($value);
    $csv_data[] = '"' . $clean_key . '","' . $clean_value . '"'; // Wrap each value in quotes to handle commas
}

$csv_line = implode(',', $csv_data) . "\n"; // Combine CSV values into one line

// Check if the CSV file exists. If not, create it and add the header.
if (!file_exists($csv_file)) {
    $header = '"Key","Value"' . "\n"; // CSV header
    file_put_contents($csv_file, $header, FILE_APPEND);
}

// Append the form data to the CSV file.
file_put_contents($csv_file, $csv_line, FILE_APPEND);

// === EMAIL HEADERS ===
$subject = "Lead Alert - " . date("Y-m-d H:i:s");
$headers = "From: leads@amznprimepublications.com\r\n";
$headers .= "Reply-To: leads@amznprimepublications.com\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-type: text/html; charset=UTF-8\r\n";
$headers .= "Message-ID: <" . md5(uniqid(time())) . "@".$_SERVER['SERVER_NAME'].">\r\n";

// === SEND MAIL ===
if (mail($to, $subject, $message, $headers)) {
    header("$redirecturl");
} else {
    header("$redirecturl?error=1");
}
exit;
?>
