<!doctype php>
<html lang="en">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Custom Files -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
    <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
    <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">

    <style>
    h1.hero-title.aos-init.aos-animate {
        line-height: 55px;
    }

    .hero-points {
        list-style: none;
        padding: 0;
        margin: 1rem 0 0 0;
        display: grid;
        gap: .75rem;
        max-width: 980px;
    }

    .hero-points li {
        display: grid;
        grid-template-columns: 28px 1fr;
        column-gap: 12px;
        align-items: flex-start;
        font-size: clamp(15px, 1.4vw, 18px);
        line-height: 1.55;
        color: white;
    }

    .check {
        width: 22px;
        height: 22px;
        margin-top: .2rem;
        border: 2px solid #fff;
        border-radius: 4px;
        position: relative;
        display: inline-block;
        flex-shrink: 0;
    }

    .check::after {
        content: "";
        position: absolute;
        left: 5px;
        top: 1px;
        width: 8px;
        height: 14px;
        border-right: 3px solid #fff;
        border-bottom: 3px solid #fff;
        transform: rotate(45deg);
    }

    /* gold highlight */
    .hi {
        color: #FF9900;
        font-weight: 600;
    }

    /* small screens: keep a single line for “Publishing Platforms” if needed */
    .sm-only {
        display: none;
    }

    @media (max-width:640px) {
        .sm-only {
            display: inline;
        }
    }
    </style>


    <title>Amzn Prime Publications | Book & eBook ing Services</title>
    <meta name="description"
        content="Discover Amzn Prime Publications for top book, eBook, and self-publishing services. Join us to bring your story to life with Amzn  Press.">
    <meta name="keywords"
        content=" Amzn Prime Publications, Book Publishing, Book Publishing Services, Publishing a Book, Book Publishing Company, ing a Book, Amazon Publishing, Lulu Publishing, Kobo Publishing, Amzn Prime Publications, Kindle Publishing">
</head>

<body>
    <?php include 'include/header.php'?>
    <section class="banner main-banner">
        <!-- banner video -->
        <!-- <div class="video-wrapper">
            <video class="mainvideo lazy" poster="assets/images/b-video.webp" autoplay="" loop="" muted=""
                playsinline="" preload="metadata" src="assets/images/b-video.mp4"></video>
        </div> -->
        <!-- banner video -->
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="hero-inner">
                        <h1 data-aos="fade-down" data-aos-duration="1100" class="hero-title">
                            Get your book published on 40+ Book<br class="sm-only"> Publishing Platforms
                        </h1>

                        <ul class="hero-points" data-aos="fade-right" data-aos-duration="1500">
                            <li>
                                <span class="check"></span>
                                <span><span class="hi">Keep 100% Royalty</span> and Ownership of Book</span>
                            </li>
                            <li>
                                <span class="check"></span>
                                <span>Simple and Smooth Process – <span class="hi">Enjoy 50% Discount</span></span>
                            </li>
                            <li>
                                <span class="check"></span>
                                <span>Publish on amazon and <span class="hi">40+ renowned platforms</span> like Amazon
                                    Kindle, Kobo, Barnes & Noble and many others</span>
                            </li>
                            <li>
                                <span class="check"></span>
                                <span><span class="hi">Expedite your journey</span> to the world's largest online
                                    marketplace</span>
                            </li>
                        </ul>
                    </div>
                    <br><br>
                    <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                            class="fas fa-phone right-icon"></i></a>
                    <a href="javascript:" id="chat_toggle" class="btn btn-blue">Live Chat <i
                            class="fas fa-comments"></i></a>
                </div>
                <div class="col-md-6">
                    <div class="get-started-form" data-aos="fade-left" data-aos-duration="1500">
                        <!-- Form Start-->
                        <div class="get-started-form main-form">
                            <form action="https://amznprimepublications.com/mail.php" method="post"
                                class="validate-letsget form-get-quote">
                                <h3 class="text-white pb-3">Start Your Publishing Journey Today!</h3>
                                <input type="text" class="required input-control form-control" name="quote[name]"
                                    required id="name" placeholder="Full Name" />
                                <input type="email" class="required input-control form-control email" id="email"
                                    required name="quote[email]" placeholder="Email">
                                <input type="tel" class="required input-control form-control" required
                                    name="quote[phone]" placeholder="Phone Number">
                                <textarea class="required input-control form-control" autocomplete="nope"
                                    name="quote[comments]" required placeholder="I am looking for..."
                                    style="height:110px;"></textarea>
                                <br>
                                <br>
                                <label class="chota_fnt"><input type="checkbox" name="bn_emailPromotional" required=""
                                        checked>
                                    Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                                    <a href="privacy-policy.php">PRIVACY POLICY </a>
                                    & <a href="terms-and-conditions.php">TERM & CONDITIONS</a> )
                                    - Carrier charges may apply for SMS. Reply STOP or UNSUBSCRIBE to STOP to
                                    unsubscribe anytime. .
                                </label>
                                <div class="py-2">

                                    <input type="hidden" name="pageurl" value="index.php">
                                    <input type="hidden" name="ip2loc_ip" value="" />
                                    <input type="hidden" name="ip2loc_isp" value="" />
                                    <input type="hidden" name="ip2loc_org" value="" />
                                    <input type="hidden" name="ip2loc_country" value="" />
                                    <input type="hidden" name="ip2loc_region" value="" />
                                    <input type="hidden" name="ip2loc_city" value="" />

                                    <input type="submit" id="register" class="btn btn-red" name="send_data"
                                        value="Let's Get Started"> <br />
                                </div>
                            </form>
                        </div> <!-- Form End -->
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="services">
        <div class="container" data-aos="fade-down" data-aos-duration="1000">
            <h6 class="title text-center"> Everything you need is all in one place:</h6>
            <h2 class="text-center">Comprehensive Publishing Solutions Tailored Just for You<span
                    class="d-block primary-color">Comprehensive Services.</span></h2>
            <div class="row align-items-center">
                <div class="row align-items-center py-4">
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon1.webp" alt="Amzn Prime Publications ">
                            <h4>Book Publishing</h4>
                            <p>Comprehensive solutions to transform your manuscript into a professionally published
                                book.</p>
                            <div class="text-right">
                                <a href="book-publishing-services.php" class="btn btn-red px-md-4">Learn more <i
                                        class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon2.webp" alt="Amzn Prime Publications ">
                            <h4>Book Marketing</h4>
                            <p>Strategic promotion and outreach to boost your book’s visibility and sales.</p>
                            <div class="text-right">
                                <a href="book-marketing-services.php" class="btn btn-red px-md-4">Learn more <i
                                        class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon3.webp" alt="Amzn Prime Publications ">
                            <h4>Audiobook</h4>
                            <p>Professional production and distribution of your book in audio format</p>
                            <div class="text-right">
                                <a href="audiobook-services.php" class="btn btn-red px-md-4">Learn more <i
                                        class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row align-items-center pb-4">
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon4.webp" alt="Amzn Prime Publications ">
                            <h4>Book Illustration Designing</h4>
                            <p>Creative design services to visually enhance your book with captivating illustrations.
                            </p>
                            <div class="text-right">
                                <a href="book-illustration-designing-services.php" class="btn btn-red px-md-4">Learn
                                    more <i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon5.webp" alt="Amzn Prime Publications ">
                            <h4>Book Editing</h4>
                            <p>Expert editing to refine your manuscript, ensuring clarity, consistency, and polish.</p>
                            <div class="text-right">
                                <a href="book-editing-services.php" class="btn btn-red px-md-4">Learn more <i
                                        class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon6.webp" alt="Amzn Prime Publications ">
                            <h4>Book Writing</h4>
                            <p>Professional writing services to craft or enhance your book’s content and narrative.</p>
                            <div class="text-right">
                                <a href="book-writing-services.php" class="btn btn-red px-md-4">Learn more <i
                                        class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row align-items-center">
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon7.webp" alt="Amzn Prime Publications ">
                            <h4>Author Website Development</h4>
                            <p>Custom website creation to build your online presence and connect with readers.</p>
                            <div class="text-right">
                                <a href="author-website-development-services.php" class="btn btn-red px-md-4">Learn more
                                    <i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon8.webp" alt="Amzn Prime Publications ">
                            <h4>Book Printing</h4>
                            <p>High-quality printing services for physical copies of your book in various formats.</p>
                            <div class="text-right">
                                <a href="book-printing-services.php" class="btn btn-red px-md-4">Learn more <i
                                        class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="ser-box">
                            <img src="assets/images/icon9.webp" alt="Amzn Prime Publications ">
                            <h4>Author Podcasts</h4>
                            <p>Engaging podcast production to help authors share their stories and connect with their
                                audience.</p>
                            <div class="text-right">
                                <a href="author-podcasts-services.php" class="btn btn-red px-md-4">Learn more <i
                                        class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>

    <!-- Signup CTA-->
    <section class="cta-signup ">
        <div class="container" data-aos="zoom-in" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <!-- <h6 class="title">Ready to publish?</h6> -->
                    <h2 class="text-white"><span class="d-block">Start Your Journey with Us Today!</h2>
                    <p class="text-white py-3">Don't wait to have your manuscript published. Contact Amzn
                        Publishing today to start your publishing adventure. Whether you want to <br> self-publish or
                        explore
                        traditional options, our staff is ready to support you every step of the way.</p>
                    <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                            class="fas fa-phone right-icon"></i></a> &nbsp; &nbsp;
                    <a href="javascript:" id="chat_toggle" class="btn btn-blue">Live Chat <i
                            class="fas fa-comments"></i></a>
                </div>
            </div>
        </div>
    </section>

    <br><br><br>



    <!-- Portfolio -->
    <section class="porfilio-slider px-md-5" id="portfolio">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <h6 class="title">Explore Our Portfolio</h6>
            <h2>Success Stories from Amzn Prime Publications </h2>
            <p class="py-4 pb-md-5 px-md-5">
                Browse our portfolio to see the diverse range of successful projects we've managed.  Our  portfolio
                showcases the quality and impact of Amzn Prime
                Publications . Each success story is a testament to our commitment to excellence and our ability to help
                authors achieve their publishing goals.
            </p>
            <div class="row">
                <div class="col-md-12" data-aos="zoom-in-up" data-aos-duration="1100">
                    <div class="port-slider-one owl-carousel owl-theme">
                        <div class="item">
                            <img class="lazy" src="assets/images/sl1.webp" data-src="assets/images/sl1.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl2.webp" data-src="assets/images/sl2.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl3.webp" data-src="assets/images/sl3.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl4.webp" data-src="assets/images/sl4.webp"
                                alt="Book Slider">
                        </div>
                    </div>
                    <div class="port-slider-two owl-carousel owl-theme">
                        <div class="item">
                            <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl6.webp" data-src="assets/images/sl6.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl7.webp" data-src="assets/images/sl7.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl8.webp" data-src="assets/images/sl8.webp"
                                alt="Book Slider">
                        </div>
                    </div>
                    <a href="javascript:" class="btn btn-red" onclick="setButtonURL();">Let’s Get Started <i
                            class="fa-solid fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
    </section> <!-- Portfolio -->

    <section class="reason">
        <div class="container-fluid" data-aos="fade-up" data-aos-duration="1000">
            <h6 class="text-center title">Our Proven Process</h6>
            <h2 class="text-center">Seamless Publishing from Start to Finish</h2>
            <p class="pb-5 text-center">Amzn Prime Publications 's simplified procedure assures a smooth transition
                from manuscript to publication. Our procedure entails <span class="d-block"> meticulous editing, expert
                    design, effective
                    marketing, and timely release. Whether you choose self-publishing or traditional publication,
                </span> we will
                accompany you through the process, ensuring your book reaches its full potential.</p>
            <div class="row align-items-center">
                <div class="parent-circles">
                    <div data-aos="zoom-in-down" data-aos-duration="1300">
                        <div class="circle-box">
                            <span class="one">01</span>
                            <h6>Initial Consultation and Project Planning</h6>
                            <p>We begin with a thorough consultation to better understand your book's vision,
                                objectives, and target audience, followed by a personalized publication strategy to lead
                                the process.</p>
                            <img src="assets/images/b-arrow.webp" alt="Amzn Prime Publications ">
                        </div>
                    </div>
                    <div data-aos="zoom-in-up" data-aos-duration="1500">
                        <div class="circle-box b-four">
                            <span class="four">02</span>
                            <h6>Expert Manuscript Editing and Design</h6>
                            <p>Our trained editors polish your book for quality and consistency, while our design team
                                develops a visually appealing cover and professional inside layout.</p>
                            <img src="assets/images/t-arrow.webp" alt="Amzn Prime Publications ">
                        </div>
                    </div>
                    <div data-aos="zoom-in-down" data-aos-duration="1800">
                        <div class="circle-box">
                            <span class="two">03</span>
                            <h6>Formatting and Production</h6>
                            <p>We skillfully style your book to suit both print and digital publication requirements,
                                preparing it for release on Amzn Books and other platforms.</p>
                            <img src="assets/images/b-arrow.webp" alt="Amzn Prime Publications ">
                        </div>
                    </div>
                    <div data-aos="zoom-in-up" data-aos-duration="2100">
                        <div class="circle-box b-five">
                            <span class="five">04</span>
                            <h6>Strategic Marketing and Distribution</h6>
                            <p>We develop and implement a bespoke marketing campaign to promote your book, utilizing
                                Amzn 's extensive distribution network to reach a large audience.</p>
                            <img src="assets/images/t-arrow.webp" alt="Amzn Prime Publications ">
                        </div>
                    </div>
                    <div data-aos="zoom-in-down" data-aos-duration="2400">
                        <div class="circle-box">
                            <span class="three">05</span>
                            <h6>Book Launch and Ongoing Support</h6>
                            <p>We help you with promotional activities during your book's debut and continue to give
                                direction to ensure your book reaches its maximum potential in the market.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="empower">
        <div class="container">
            <h2 data-aos="fade-up" data-aos-duration="1200" class="text-white">Expand Your Reach Digitally</span></h2>
            <div class="row align-items-center pt-3">
                <div class="col-md-6 text-center">
                    <img data-aos="fade-right" data-aos-duration="2500" src="assets/images/emp1.webp"
                        alt="Amzn Prime Publications " width="90%">
                </div>
                <div class="col-md-6">
                    <p data-aos="fade-left" data-aos-duration="2500" class="py-4 text-white">
                        Amzn eBook publishing can help you realize your manuscript's full potential. Our
                        simplified procedure enables authors to convert their work into professionally formatted ebooks,
                        making it easier than ever to reach readers worldwide.
                        <br>
                        Amzn Prime Publications gives you complete control over your creative vision while
                        providing expert assistance and industry-leading tools. Our platform has a simple interface that
                        makes it easy to publish your book, from uploading your content to customizing its design.
                        Whether you're a first-time author or a seasoned writer, Amzn eBook publishing
                        allows you to distribute your work digitally across several devices and platforms, maximizing
                        visibility.
                        <br>
                        Partner with us to take your book from concept to digital blockbuster and reach a worldwide
                        audience via Amzn 's huge network.
                    </p>
                    <img data-aos="fade-up" data-aos-duration="2500" src="assets/images/emp2.webp"
                        alt="Amzn Prime Publications " width="90%">
                </div>
            </div>
        </div>
        </div>
    </section>

    <!-- Client testmonial -->
    <section class="  " id="testmonial">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-12 py-4 text-center">
                    <!-- <h6 class="title">Author say it best</h6> -->
                    <h2>Hear What Our Happy Authors Are Saying!</h2>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="owl-carousel owl-theme monial">
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover6.webp"
                                        data-src="assets/images/bcover6.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">Working with Amzn Prime Publications was a dream come true!
                                        From start to finish, their team was incredibly supportive and knowledgeable.
                                        They made the entire publishing process feel seamless, and I'm thrilled with how
                                        my book turned out. I couldn’t have asked for a better experience or a more
                                        professional team to bring my vision to life!</p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>Declan Flood</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover2.webp"
                                        data-src="assets/images/bcover2.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">As a first-time author, I was overwhelmed with the idea of
                                        publishing my book. The team at Amzn Prime Publications made everything so easy
                                        and straightforward. They walked me through each step, offered fantastic advice,
                                        and truly cared about my success. My book looks amazing, and I’m already
                                        reaching readers all over the world. Highly recommend! </p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>LP Munro</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover3.webp"
                                        data-src="assets/images/bcover3.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">Amzn Prime Publications was the perfect solution for me. The
                                        platform was easy to use, and I loved having creative control while also getting
                                        expert support. The whole process was smooth, and my ebook is now available on
                                        multiple platforms. I’ve received so much positive feedback from readers, and I
                                        owe it all to the fantastic team at Amzn Prime Publications !</p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>Ladybird Bip</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover4.webp"
                                        data-src="assets/images/bcover4.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">From the moment I signed up with Amzn Prime Publications, I
                                        knew I was in good hands. The editors and designers were top-notch, and they
                                        helped turn my manuscript into a polished, professional book. The marketing
                                        advice was also invaluable, and I've seen my book sales soar since launch. Thank
                                        you for making my publishing dreams a reality!</p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>Penny Faibland</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover5.webp"
                                        data-src="assets/images/bcover5.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">Amzn Prime Publications exceeded my expectations in every
                                        way. The level of care, attention to detail, and professionalism they provided
                                        was outstanding. They handled everything from editing to cover design
                                        beautifully, and I felt supported throughout the entire journey. Seeing my book
                                        on the Amzn platform is a feeling I can’t describe – it’s just incredible!</p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>Neal Smith</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Client testmonial End -->
    <section class="tailor">
        <div class="container">
            <div class="row align-items-center pt-3">
                <div class="col-md-5">
                </div>
                <div class="col-md-7">
                    <div class="box-shade">
                        <h6 class="title">Amzn Prime Publications</h6>
                        <h2>Your Pathway to Independence</h2>
                        <p>Choose us for an independent publishing experience with the support of a trusted name. Our
                            Amzn Prime Publications solutions offer you creative freedom while providing
                            access to industry-leading tools and resources, ensuring your book is professionally
                            presented and widely available.</p>
                        <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                                class="fas fa-phone right-icon"></i></a>
                        <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue">Live Chat <i
                                class="fas fa-comments"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Start-->
    <section class="faq-sec pb-0">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-7 pb-md-5 ">
                    <!-- <h6 class="title">Check whether your question is in FAQs</h6> -->
                    <h2>Frequently Asked Questions</h2>
                    <div id="accordion">
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseOne">Q.1: What
                                    types of publishing services does Amzn Prime Publications offer?</a>
                            </div>
                            <div id="collapseOne" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Amzn Prime Publications provides a wide range of publishing services, such as
                                        conventional publishing, self-publishing, eBook publishing, audiobook
                                        production, and print-on-demand. Our services range from manuscript editing and
                                        design to marketing and distribution and are tailored to each author's needs.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseTwo">Q.2: How do I
                                    start the publishing process with Amzn Prime Publications ?</a>
                            </div>
                            <div id="collapseTwo" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Starting with Amzn Prime Publications is simple! To book an initial
                                        consultation, please contact us through our website or phone us directly. During
                                        this meeting, we will discuss your objectives, analyze your work, and devise a
                                        personalized publishing strategy that is consistent with your vision.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseThree">Q.3: What’s
                                    the difference between traditional and self-publishing with Amzn Prime Publications
                                    ?</a>
                            </div>
                            <div id="collapseThree" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Amzn Prime Publications handles the whole process of conventional publishing,
                                        from editing and design to marketing and distribution, typically using a
                                        royalty-based remuneration model. Self-publishing, on the other hand, allows you
                                        to have complete control over the process, allowing you to make all the
                                        decisions while we provide assistance and tools to ensure your success.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseFour">Q.4: How does
                                    Amzn Prime Publications help authors with book marketing?</a>
                            </div>
                            <div id="collapseFour" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Amzn Prime Publications provides strong marketing help to guarantee your book
                                        reaches its intended audience. Our services include online and offline
                                        promotional techniques, social media marketing, email campaigns, and book
                                        placement in our online shop, all of which contribute to increased awareness and
                                        sales for your book.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseFive">Q.5: Can I
                                    publish both print books and eBooks with Amzn Prime Publications ?</a>
                            </div>
                            <div id="collapseFive" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Absolutely! Amzn Prime Publications provides options for both print books and
                                        eBooks. Whether you prefer a physical copy for book signings and events or a
                                        digital version to reach readers globally, we have the resources and expertise
                                        to publish in both formats, ensuring your book is available wherever your
                                        readers are.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseSix">Q.6: What kind
                                    of royalties can I expect with Amzn Prime Publications ?</a>
                            </div>
                            <div id="collapseSix" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Royalties with Amzn Prime Publications differ depending on whether you choose
                                        traditional or self-publishing. Self-publishing allows you to earn a substantial
                                        proportion of the sale price. We work with you to find the optimum royalty
                                        structure for your publishing goals and the services you select.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseSeven">Q.7: Will I
                                    retain the rights to my book when publishing with Amzn Prime Publications ?</a>
                            </div>
                            <div id="collapseSeven" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Yes, when you choose to self-publish with Amzn Prime Publications , you maintain
                                        complete ownership of your work. You have complete control over the product's
                                        manufacturing, distribution, and marketing. Traditional publication rights are
                                        negotiated using the provisions outlined in your publishing contract.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <img src="assets/images/faq.webp" alt="Amzn Prime Publications " width="100%">
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ End-->

    <section class="bottom-form">
        <div class="container" data-aos="zoom-in" data-aos-duration="1200">
            <div class="row">
                <div class="col-md-12">
                    <div class="get-started-form main-form">
                        <form action="https://amznprimepublications.com/mail.php" method="post"
                            class="validate-bottom-form form-get-quote">
                            <h6 class="text-white text-center">Feel Free to request now</h6>
                            <h2 class="text-center text-white pb-3">Make an Appointment</h2>
                            <input type="text" class="required input-control form-control" name="quote[name]" required
                                id="name" placeholder="Full Name" />
                            <input type="email" class="required input-control form-control email" id="emailTwo" required
                                name="quote[email]" placeholder="Email">
                            <input type="tel" class="required input-control form-control" name="quote[phone]" required
                                placeholder="Phone Number">
                            <!-- <input type="number" class="required input-control form-control" name="budget"
                            id="budget" placeholder="Budget" /> -->
                            <select name="quote[services]" id="ser-select"
                                class="required input-control form-control d-inline-block">
                                <option selected>Select Services</option>
                                <option value="Digital Book Publishing">Digital Book Publishing</option>
                                <option value="Book Marketing Service">Book Marketing Service</option>
                                <option value="Ghostwriting Service">Ghostwriting Service</option>
                                <option value="Fiction Writing Service">Fiction Writing Service</option>
                                <option value="Children’s Books Service">Children’s Books Service</option>
                                <option value="Book Editing & Proofreading Service">Book Editing & Proofreading Service
                                </option>
                                <option value="Book Cover Designing">Book Cover Designing</option>
                                <option value="Illustrations & Graphics Service">Illustrations & Graphics Service
                                </option>
                                <option value="Book Printing Service">Book Printing Service</option>
                                <option value="Audiobook Production">Audiobook Production</option>
                                <option value="Author Website Service">Author Website Service</option>
                                <option value="Blurb Writing Service">Blurb Writing Service</option>
                                <option value="Amazon Book Description">Amazon Book Description</option>
                                <option value="Amazon Book Listing Optimization">Amazon Book Listing Optimization
                                </option>
                                <option value="Amazon Book Paid Ads">Amazon Book Paid Ads</option>
                                <option value="Amazon Central Account">Amazon Central Account</option>
                                <option value="Amazon A + Content">Amazon A + Content</option>
                                <option value="Book Trailer">Book Trailer</option>
                                <option value="Featured Articles">Featured Articles</option>
                            </select>
                            <textarea class="required input-control form-control" autocomplete="nope"
                                name="quote[comments]" placeholder="About Project"></textarea>
                            <div class="pt-3 text-center">
                                <label class="chota_fnt d-inline-block"><input type="checkbox"
                                        name="bn_emailPromotional" required="" checked>
                                    Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                                    <a href="privacy-policy.php">PRIVACY POLICY </a>
                                    & <a href="terms-and-conditions.php">TERM & CONDITIONS</a> )
                                    - Carrier charges may apply for SMS. Reply STOP or UNSUBSCRIBE to STOP to
                                    unsubscribe anytime.
                                    anytime.
                                </label>
                            </div>
                            <input type="hidden" name="pageurl" value="index.php">
                            <input type="hidden" name="ip2loc_ip" value="" />
                            <input type="hidden" name="ip2loc_isp" value="" />
                            <input type="hidden" name="ip2loc_org" value="" />
                            <input type="hidden" name="ip2loc_country" value="" />
                            <input type="hidden" name="ip2loc_region" value="" />
                            <input type="hidden" name="ip2loc_city" value="" />
                            <div class="text-center">
                                <input type="submit" id="register" class="btn btn-red" name="send_data"
                                    value="Let's Get Started" onclick="abc()"> <br />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include 'include/footer.php'?>
    <?php include 'include/chat.php'?>


    <a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

    <div class="popupform modal" id="popupform">
        <div class="modal-content">
            <div class="modal-body p-0">
                <button class="close-popup"><i class="fa-solid fa-xmark"></i></button>
                <div class="popup-bann">
                    <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp" alt="">
                </div>
                <div class="popup-content">
                    <h2>
                        SIGNUP NOW TO AVAIL
                        Get Your <span class="d-block primary-color"> THE 40% DISCOUNT OFFER </span>
                        GET A FREE CONSULTATION CALL
                    </h2>
                    <form action="https://amznprimepublications.com/mail.php" method="post"
                        class="form-get-quote validate-popup-form">
                        <div class="row p-3">
                            <input type="text" class="required form-control" name="quote[name]" required="" id="name"
                                placeholder="Full Name" aria-required="true">
                            <input type="email" class="required form-control email" id="email" required
                                name="quote[email]" placeholder="Email">
                            <input type="tel" class="required form-control" required name="quote[phone]"
                                placeholder="Phone Number">
                            <textarea class="required form-control" autocomplete="nope" name="quote[comments]" required
                                placeholder="I am looking for..."
                                placeholder="Breif discuss about your book..."></textarea>
                            <div class="col-md-12 pt-md-4 text-center">
                                <input type="submit" class="btn btn-red" name="send_data" value="Submit now">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop" id="modalBackdrop"></div>
    <script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script type="text/javascript" src="assets/js/libs.js"></script>
    <script type="text/javascript" src="assets/js/functions.js"></script>


    <script>
    function onNewEvent(event) {
        switch (event.type) {
            case "message":
            case "rich_message":
            case "file":
                LiveChatWidget.call("maximize");
                break;
            default:
                break;
        }
    }

    window.addEventListener("load", function() {
        // Ensure widget is loaded before calling maximize
        LiveChatWidget.on("ready", function() {
            // Open chat on page load
            LiveChatWidget.call("maximize");

            // Open chat on custom button click
            const chatToggle = document.getElementById("chat_toggle");
            if (chatToggle) {
                chatToggle.addEventListener("click", function() {
                    LiveChatWidget.call("maximize");
                });
            }
        });

        LiveChatWidget.on("new_event", onNewEvent);
    });
    </script>


    <script>
    $(document).ready(function() {

        var currentIP;
        var key = '';
        var currentIP = $("meta[name=ip2loc]").attr('content');
        var pgurl = $("meta[name=pageurl]").attr('content');
        //   console.log('hi you are safe here..')
        $.ajax({
            method: 'get',
            url: '//pro.ip-api.com/json/' + currentIP,
            data: {
                key: key
            },
            success: function(data) {
                console.log(data)
                if (data) {
                    $('input[name=ip2loc_ip]').val(data.query);
                    $('input[name=ip2loc_isp]').val(data.isp);
                    $('input[name=ip2loc_org]').val(data.org);
                    $('input[name=ip2loc_country]').val(data.country);
                    $('input[name=ip2loc_region]').val(data.regionName);
                    $('input[name=ip2loc_city]').val(data.city);
                    //$('input[name=pageurl]').val(pageurl);



                }
            }
        });
    });
    </script>

</body>

<!-- Mirrored from amznprimepublications.com/ by HTTrack Website Copier/3.x [XR&CO'2014], Thu, 01 May 2025 01:23:47 GMT -->

</html>