<!doctype html>
<html lang="en">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Custom Files -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
    <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" />
    <link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
    <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">




    <meta name="ip2loc" content="2400:adc1:4ac:3300:7884:68ef:c6f0:ccee">
    <title>Book Publishing Services | Amzn Prime Publications</title>
    <meta name="description"
        content="Explore top book publishing services at Amzn Prime Publications From self-publishing to Amazon, Kindle, Lulu, and Kobo, we turn your manuscript into a bestseller.">
</head>

<body data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">
    <?php include 'include/header.php'?>
    <section class="banner main-banner inner-banner">
        <div class="container" data-aos="fade-down" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-6" data-aos="fade-in-up" data-aos-duration="1100">
                    <h1>Amzn Prime Publications – Your Trusted Book Publishing Partner</h1>
                    <p class="text-white py-3">
                        We at Amzn Prime Publications believe that each story deserves to be told. Whether you're an
                        experienced author or a first-time writer, our comprehensive book publishing services will help
                        you turn your work into a published masterpiece. With decades of experience in both traditional
                        and self-publishing, we provide tailored solutions for each author, ensuring that your work
                        reaches the widest potential audience. Dive into the world of publishing a book with us and
                        let's make your literary ambitions come true.
                    </p>
                    <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                            class="fas fa-phone right-icon"></i></a>
                    <a href="javascript:" id="chat_toggle" class="btn btn-blue">Live Chat <i
                            class="fas fa-comments"></i></a>
                </div>
                <div class="col-md-6">
                    <div class="get-started-form" data-aos="fade-down" data-aos-duration="1200">
                        <!-- Form Start-->
                        <div class="get-started-form main-form">
                            <form action="https://amznprimepublications.com/mail.php" method="post"
                                class="validate-letsget form-get-quote">
                                <h3 class="text-white pb-3">Get a Free Quote</h3>
                                <input type="text" class="required input-control form-control" name="quote[name]"
                                    required id="name" placeholder="Full Name" />
                                <input type="email" class="required input-control form-control email" id="email"
                                    required name="quote[email]" placeholder="Email">
                                <input type="tel" class="required input-control form-control" required
                                    name="quote[phone]" placeholder="Phone Number">
                                <textarea class="required input-control form-control" autocomplete="nope"
                                    name="quote[comments]" required placeholder="I am looking for..."
                                    style="height:110px;"></textarea>
                                <br>
                                <br>
                                <label class="chota_fnt"><input type="checkbox" name="bn_emailPromotional" required=""
                                        checked>
                                    Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                                    <a href="privacy-policy.php">PRIVACY POLICY </a>
                                    & <a href="terms-and-conditions.php">TERM & CONDITIONS</a> )
                                    - Carrier charges may apply for SMS. Reply STOP or UNSUBSCRIBE to STOP to
                                    unsubscribe anytime. .
                                </label>
                                <div class="py-2">

                                    <input type="hidden" name="pageurl" value="book-publishing-services.php">
                                    <input type="hidden" name="ip2loc_ip" value="" />
                                    <input type="hidden" name="ip2loc_isp" value="" />
                                    <input type="hidden" name="ip2loc_org" value="" />
                                    <input type="hidden" name="ip2loc_country" value="" />
                                    <input type="hidden" name="ip2loc_region" value="" />
                                    <input type="hidden" name="ip2loc_city" value="" />

                                    <input type="submit" id="register" class="btn btn-red" name="send_data"
                                        value="Let's Get Started"> <br />
                                </div>
                            </form>
                        </div> <!-- Form End -->
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="tailor cont-detail">
        <div class="container py-5">
            <div class="row align-items-center pt-3">
                <div class="col-md-5">
                </div>
                <div class="col-md-7">
                    <div class="box-shade">
                        <h2 data-aos="fade-up" data-aos-duration="1300">From Manuscript to Market: Comprehensive Book
                            Publishing Services</h2>
                        <p class="py-3" data-aos="fade-up" data-aos-duration="1500">Amzn Prime Publications turns your
                            manuscript into a polished, marketable
                            book. Our complete book publishing services encompass all aspects of the process, from early
                            editing and design to final distribution. We provide bespoke solutions whether you want to
                            go the traditional way or self-publish.
                            <br>
                            For those interested in self-publishing, we offer expertise in platforms such as Amazon
                            Publishing, Lulu Publishing, Kindle Publishing, and Kobo Publishing. Our team ensures your
                            book meets industry standards and reaches your target audience through these popular
                            channels. With our help, you can successfully negotiate the publishing industry and see your
                            book prosper on the market.
                            <br>
                            Let Amzn Prime Publications handle the technicalities of publishing a book while you
                            concentrate on what you do best: writing.
                        </p>
                        <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                                class="fas fa-phone right-icon"></i></a>
                        <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue">Live Chat <i
                                class="fas fa-comments"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="empower">
        <div class="container" data-aos="fade-right" data-aos-duration="1000">
            <div class="row align-items-center pt-3">
                <div class="col-md-6 text-center">
                    <img class="lazy" src="assets/images/emp1.webp" data-src="assets/images/emp1.webp"
                        alt="Amzn Prime Publications " width="90%">
                </div>
                <div class="col-md-6">
                    <h2 class="text-white">Publishing a Book Made Simple and Effective</h2>
                    <p class="py-4 text-white">
                        Publishing  a book has never been easier with Amzn Prime Publications Our streamlined
                        process removes self-publishing's complexity, offering you a clear path from manuscript to
                        market. We guide you through every step, from manuscript preparation to final distribution.
                        Whether you're leveraging Amazon publishing, Lulu publishing, or Kobo publishing, we provide
                        expert support to ensure your book meets high standards and reaches your target audience.
                        <br>
                        At Amzn Prime Publications , we offer customized solutions that fit your needs, making self
                        publishing a book straightforward and effective. Enjoy full creative control and professional
                        assistance to bring your book to life. Let us handle the technical aspects so you can focus on
                        your writing and achieve publishing success with confidence.
                    </p>
                </div>
            </div>
        </div>
        </div>
    </section>

    <section class="book-sell">
        <div class="container" data-aos="zoom-in" data-aos-duration="1200">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h2>Partner with a Leading Book Publishing Company You Can Trust</h2>
                    <p class="py-2">When it comes to publishing a book, working with a reputable book publishing company
                        makes all the difference. Amzn Prime Publications takes pride in being a prominent brand,
                        providing complete book publishing services suited to your needs. Our skilled team oversees
                        every publishing process step, ensuring your book is professionally edited, designed, and
                        delivered.
                        <br>
                        We are devoted to quality and openness and will provide you with the help and experience you
                        need to manage the intricacies of publishing. With us, you can be confident that your work is in
                        qualified hands and will stand out in the marketplace. Choose Amzn Prime Publications and have
                        the assurance of working with a business committed to your publication success.
                    </p>
                    <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                            class="fas fa-phone right-icon"></i></a>
                    <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue">Live Chat <i
                            class="fas fa-comments"></i></a>
                </div>
                <div class="col-md-6">
                    <img class="lazy" src="assets/images/emp2.webp" data-src="assets/images/emp2.webp"
                        alt="Amzn Prime Publications " width="90%">
                </div>
            </div>
        </div>
    </section>
    <section class="book-sell">
        <div class="container" data-aos="zoom-in" data-aos-duration="1200">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <img class="lazy" src="assets/images/pub.webp" data-src="assets/images/pub.webp"
                        alt="Amzn Prime Publications " width="90%">
                </div>
                <div class="col-md-6">
                    <h2>Reach a Global Audience with Our Strategic Publishing Solutions</h2>
                    <p class="py-3">Amzn Prime Publications 's strategic publishing options can help you reach a global
                        audience for your book. We specialize in leveraging major platforms such as Kobo Publishing and
                        Kindle Publishing to ensure your book gets global visibility. Our team expertly navigates these
                        channels, optimizing your book's presence on each platform to attract readers across different
                        regions. We handle everything from initial formatting to distribution and marketing to guarantee
                        that your book is available to a wide range of audiences.
                        <br>
                        We not only publish your book, but also position it for worldwide success. Trust us to handle
                        the complications of foreign publication so you can focus on what you do best: writing. Gain
                        global visibility and easily interact with readers all around the world.
                    </p>
                    <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                            class="fas fa-phone right-icon"></i></a>
                    <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue">Live Chat <i
                            class="fas fa-comments"></i></a>
                </div>
            </div>
        </div>
    </section>

    <!-- Portfolio -->
    <section class="porfilio-slider px-md-5" id="portfolio">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <h6 class="title">Explore Our Portfolio</h6>
            <h2>Success Stories from Amzn Prime Publications </h2>
            <p class="py-4 pb-md-5 px-md-5">
                Browse our portfolio to see the diverse range of successful projects we've managed. our portfolio
                showcases the quality and impact of Amzn Prime Publications . Each success story is a testament to our
                commitment to excellence and our ability to help authors achieve their publishing goals.
            </p>
            <div class="row">
                <div class="col-md-12" data-aos="zoom-in-up" data-aos-duration="1100">
                    <div class="port-slider-one owl-carousel owl-theme">
                        <div class="item">
                            <img class="lazy" src="assets/images/sl1.webp" data-src="assets/images/sl1.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl2.webp" data-src="assets/images/sl2.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl3.webp" data-src="assets/images/sl3.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl4.webp" data-src="assets/images/sl4.webp"
                                alt="Book Slider">
                        </div>
                    </div>
                    <div class="port-slider-two owl-carousel owl-theme">
                        <div class="item">
                            <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl6.webp" data-src="assets/images/sl6.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl7.webp" data-src="assets/images/sl7.webp"
                                alt="Book Slider">
                        </div>
                        <div class="item">
                            <img class="lazy" src="assets/images/sl8.webp" data-src="assets/images/sl8.webp"
                                alt="Book Slider">
                        </div>
                    </div>
                    <a href="javascript:" class="btn btn-red" onclick="setButtonURL();">Let’s Get Started <i
                            class="fa-solid fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
    </section> <!-- Portfolio -->

    <!-- Client testmonial -->
    <section class="  " id="testmonial">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-12 py-4 text-center">
                    <!-- <h6 class="title">Author say it best</h6> -->
                    <h2>Hear What Our Happy Authors Are Saying!</h2>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="owl-carousel owl-theme monial">
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover6.webp"
                                        data-src="assets/images/bcover6.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">Working with Amzn Prime Publications was a dream come true!
                                        From start to finish, their team was incredibly supportive and knowledgeable.
                                        They made the entire publishing process feel seamless, and I'm thrilled with how
                                        my book turned out. I couldn’t have asked for a better experience or a more
                                        professional team to bring my vision to life!</p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>Declan Flood</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover2.webp"
                                        data-src="assets/images/bcover2.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">As a first-time author, I was overwhelmed with the idea of
                                        publishing my book. The team at Amzn Prime Publications made everything so easy
                                        and straightforward. They walked me through each step, offered fantastic advice,
                                        and truly cared about my success. My book looks amazing, and I’m already
                                        reaching readers all over the world. Highly recommend! </p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>LP Munro</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover3.webp"
                                        data-src="assets/images/bcover3.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">Amzn Prime Publications was the perfect solution for me. The
                                        platform was easy to use, and I loved having creative control while also getting
                                        expert support. The whole process was smooth, and my ebook is now available on
                                        multiple platforms. I’ve received so much positive feedback from readers, and I
                                        owe it all to the fantastic team at Amzn Prime Publications !</p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>Ladybird Bip</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover4.webp"
                                        data-src="assets/images/bcover4.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">From the moment I signed up with Amzn Press ing, I knew I was
                                        in good hands. The editors and designers were top-notch, and they helped turn my
                                        manuscript into a polished, professional book. The marketing advice was also
                                        invaluable, and I've seen my book sales soar since launch. Thank you for making
                                        my publishing dreams a reality!</p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>Penny Faibland</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                        <div class="review-box">
                            <div class="row py-3 align-items-center">
                                <div class="col-md-4 text-center">
                                    <img class="lazy" src="assets/images/bcover5.webp"
                                        data-src="assets/images/bcover5.webp" alt="Amzn Prime Publications "
                                        width="70%">
                                </div>
                                <div class="col-md-8 text-right">
                                    <p class="review-para">Amzn Prime Publications exceeded my expectations in every
                                        way. The level of care, attention to detail, and professionalism they provided
                                        was outstanding. They handled everything from editing to cover design
                                        beautifully, and I felt supported throughout the entire journey. Seeing my book
                                        on the Amzn platform is a feeling I can’t describe – it’s just incredible!</p>
                                    <div class="row">
                                        <div class="col-md-6 text-left">
                                            <div class="author-info">
                                                <h6>Neal Smith</h6>
                                                <p>1 Review</p>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Client testmonial End -->


    <!-- FAQ Start-->
    <section class="faq-sec pb-0">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-7 pb-md-5 ">
                    <!-- <h6 class="title">Check whether your question is in FAQs</h6> -->
                    <h2>Frequently Asked Questions</h2>
                    <div id="accordion">
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseOne">Q.1: What
                                    types of publishing services does Amzn Prime Publications offer?</a>
                            </div>
                            <div id="collapseOne" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Amzn Prime Publications provides a wide range of publishing services, such as
                                        conventional publishing, self-publishing, eBook publishing, audiobook
                                        production, and print-on-demand. Our services range from manuscript editing and
                                        design to marketing and distribution and are tailored to each author's needs.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseTwo">Q.2: How do I
                                    start the publishing process with Amzn Prime Publications ?</a>
                            </div>
                            <div id="collapseTwo" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Starting with Amzn Prime Publications is simple! To book an initial
                                        consultation, please contact us through our website or phone us directly. During
                                        this meeting, we will discuss your objectives, analyze your work, and devise a
                                        personalized publishing strategy that is consistent with your vision.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseThree">Q.3: What’s
                                    the difference between traditional and self-publishing with Amzn Prime Publications
                                    ?</a>
                            </div>
                            <div id="collapseThree" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Amzn Prime Publications handles the whole process of conventional publishing,
                                        from editing and design to marketing and distribution, typically using a
                                        royalty-based remuneration model. Self-publishing, on the other hand, allows you
                                        to have complete control over the process, allowing you to make all the
                                        decisions while we provide assistance and tools to ensure your success.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseFour">Q.4: How does
                                    Amzn Prime Publications help authors with book marketing?</a>
                            </div>
                            <div id="collapseFour" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Amzn Prime Publications provides strong marketing help to guarantee your book
                                        reaches its intended audience. Our services include online and offline
                                        promotional techniques, social media marketing, email campaigns, and book
                                        placement in our online shop, all of which contribute to increased awareness and
                                        sales for your book.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseFive">Q.5: Can I
                                    publish both print books and eBooks with Amzn Prime Publications ?</a>
                            </div>
                            <div id="collapseFive" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Absolutely! Amzn Prime Publications provides options for both print books and
                                        eBooks. Whether you prefer a physical copy for book signings and events or a
                                        digital version to reach readers globally, we have the resources and expertise
                                        to publish in both formats, ensuring your book is available wherever your
                                        readers are.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseSix">Q.6: What kind
                                    of royalties can I expect with Amzn Prime Publications ?</a>
                            </div>
                            <div id="collapseSix" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Royalties with Amzn Prime Publications differ depending on whether you choose
                                        traditional or self-publishing. Self-publishing allows you to earn a substantial
                                        proportion of the sale price. We work with you to find the optimum royalty
                                        structure for your publishing goals and the services you select.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <a class="collapsed card-link" data-toggle="collapse" href="#collapseSeven">Q.7: Will I
                                    retain the rights to my book when publishing with Amzn Prime Publications ?</a>
                            </div>
                            <div id="collapseSeven" class="collapse" data-parent="#accordion">
                                <div class="card-body">
                                    <p>
                                        Yes, when you choose to self-publish with Amzn Prime Publications , you maintain
                                        complete ownership of your work. You have complete control over the product's
                                        manufacturing, distribution, and marketing. Traditional publication rights are
                                        negotiated using the provisions outlined in your publishing contract.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <img src="assets/images/faq.webp" alt="Amzn Prime Publications " width="100%">
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ End-->

    <section class="bottom-form">
        <div class="container" data-aos="zoom-in" data-aos-duration="1200">
            <div class="row">
                <div class="col-md-12">
                    <div class="get-started-form main-form">
                        <form action="https://amznprimepublications.com/mail.php" method="post"
                            class="validate-bottom-form form-get-quote">
                            <h6 class="text-white text-center">Feel Free to request now</h6>
                            <h2 class="text-center text-white pb-3">Make an Appointment</h2>
                            <input type="text" class="required input-control form-control" name="quote[name]" required
                                id="name" placeholder="Full Name" />
                            <input type="email" class="required input-control form-control email" id="emailTwo" required
                                name="quote[email]" placeholder="Email">
                            <input type="tel" class="required input-control form-control" name="quote[phone]" required
                                placeholder="Phone Number">
                            <!-- <input type="number" class="required input-control form-control" name="budget"
                            id="budget" placeholder="Budget" /> -->
                            <select name="quote[services]" id="ser-select"
                                class="required input-control form-control d-inline-block">
                                <option selected>Select Services</option>
                                <option value="Digital Book Publishing">Digital Book Publishing</option>
                                <option value="Book Marketing Service">Book Marketing Service</option>
                                <option value="Ghostwriting Service">Ghostwriting Service</option>
                                <option value="Fiction Writing Service">Fiction Writing Service</option>
                                <option value="Children’s Books Service">Children’s Books Service</option>
                                <option value="Book Editing & Proofreading Service">Book Editing & Proofreading Service
                                </option>
                                <option value="Book Cover Designing">Book Cover Designing</option>
                                <option value="Illustrations & Graphics Service">Illustrations & Graphics Service
                                </option>
                                <option value="Book Printing Service">Book Printing Service</option>
                                <option value="Audiobook Production">Audiobook Production</option>
                                <option value="Author Website Service">Author Website Service</option>
                                <option value="Blurb Writing Service">Blurb Writing Service</option>
                                <option value="Amazon Book Description">Amazon Book Description</option>
                                <option value="Amazon Book Listing Optimization">Amazon Book Listing Optimization
                                </option>
                                <option value="Amazon Book Paid Ads">Amazon Book Paid Ads</option>
                                <option value="Amazon Central Account">Amazon Central Account</option>
                                <option value="Amazon A + Content">Amazon A + Content</option>
                                <option value="Book Trailer">Book Trailer</option>
                                <option value="Featured Articles">Featured Articles</option>
                            </select>
                            <textarea class="required input-control form-control" autocomplete="nope"
                                name="quote[comments]" placeholder="About Project"></textarea>
                            <div class="pt-3 text-center">
                                <label class="chota_fnt d-inline-block"><input type="checkbox"
                                        name="bn_emailPromotional" required="" checked>
                                    Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                                    <a href="privacy-policy.php">PRIVACY POLICY </a>
                                    & <a href="terms-and-conditions.php">TERM & CONDITIONS</a> )
                                    - Carrier charges may apply for SMS. Reply STOP or UNSUBSCRIBE to STOP to
                                    unsubscribe anytime.
                                    anytime.
                                </label>
                            </div>
                            <input type="hidden" name="pageurl" value="book-publishing-services.php">
                            <input type="hidden" name="ip2loc_ip" value="" />
                            <input type="hidden" name="ip2loc_isp" value="" />
                            <input type="hidden" name="ip2loc_org" value="" />
                            <input type="hidden" name="ip2loc_country" value="" />
                            <input type="hidden" name="ip2loc_region" value="" />
                            <input type="hidden" name="ip2loc_city" value="" />
                            <div class="text-center">
                                <input type="submit" id="register" class="btn btn-red" name="send_data"
                                    value="Let's Get Started" onclick="abc()"> <br />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="container" data-aos="zoom-in" data-aos-duration="1000">
            <div class="row">
                <div class="col-md-4">
                    <nav>
                        <ul class="menu">
                            <li class="pb-4 logo">
                                <a href="index.php">
                                    <img src="assets/images/logo.png" alt="Amzn Prime Publications " />
                                </a>
                            </li>
                            <li>
                                <p class="text-white">Amzn Prime Publications- Your trusted partner for exceptional
                                    ghostwriting, editing, design, publishing, and marketing solutions.</p>
                            </li>
                        </ul>
                    </nav>
                </div>
                <div class="col-md-2">
                    <nav>
                        <ul class="menu">
                            <h5 class="pb-2 text-white">Quick Links</h5>
                            <li><a href="index.php">Home</a></li>
                            <li><a href="index.php">Services</a></li>
                            <li><a href="index.php#portfolio">Portfolio</a></li>
                            <li><a href="index.php#testmonial">Testmonials</a></li>
                            <li><a href="contact-us.php">Contact Us</a></li>
                        </ul>
                    </nav>
                </div>
                <div class="col-md-2">
                    <ul class="menu">
                        <h5 class="pb-2 mt-md-0 mt-2 text-white">Services</h5>
                        <li><a href="book-publishing-services.php">Book Publishing</a></li>
                        <li><a href="book-illustration-designing-services.php">Custom Illustration</a></li>
                        <li><a href="book-marketing-services.php">Book Marketing Services</a></li>
                        <li><a href="audiobook-services.php">Audiobook Services</a></li>
                        <li><a href="author-podcasts-services.php">Author Podcast Services</a></li>
                    </ul>
                </div>
                <div class="col-md-4">
                    <nav>
                        <ul class="menu">
                            <ul class="menu mb-3">
                                <h5 class="pb-2 text-white">Contact</h5>
                                <li><a href="tel:+15043538316"><i class="fas fa-phone-alt"></i> (504) 353-8316</a></li>
                                <li><a href=""><i class="fas fa-envelope"></i>info@amznprimepublications.com</a>
                                </li>
                                <li><a href="#" target="_blank"><i class="fas fa-map-marker-alt"></i>Mailing Address:
                                        2333 Alexandria Dr, Lexington, KY 40504, United States</a></li>
                                <div class="social-icons">
                                    <li><a href="javascirpt:void(0);" target="_blank" rel="noreferrer"><i
                                                class="fab fa-facebook-f"></i></a></li>
                                    <li><a href="javascirpt:void(0);" target="_blank" rel="noreferrer"><i
                                                class="fab fa-instagram"></i></a></li>
                                    <li><a href="javascript:void(0);" target="_blank" rel="noreferrer"><i
                                                class="fab fa-twitter"></i></a></li>
                                    <li><a href="javascirpt:void(0);" target="_blank" rel="noreferrer"><i
                                                class="fab fa-pinterest"></i></a></li>
                                    <li><a href="javascirpt:void(0);" target="_blank" rel="noreferrer"><i
                                                class="fab fa-youtube"></i></a></li>
                                    <!-- <li><a href="javascript:" target="_blank" rel="noreferrer"><i class="fab fa-linkedin-in"></i></a></li> -->
                                </div>
                            </ul>
                        </ul>
                    </nav>
                </div>
                <div class="col-md-12 pt-3">
                    <p class="text-white text-center">
                        Disclaimer: The logo, name and graphics of Amzn Prime Publications and its products & services
                        are the trademarks of Amzn Prime Publications . All other company names, brand names, trademarks
                        and logos mentioned on this website are the property of their respective owners and do not
                        constitute or imply endorsement, sponsorship or recommendation thereof by Amzn Prime
                        Publications and do not constitute or imply any association or relationship with amazon.com with
                        the respective trademark owner.
                    </p>
                </div>
            </div>
        </div>
        <div class="copyright">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <a href="index.php"><strong>&copy; 2025 Copyright Amzn Prime Publications. All Rights
                                Reserved.</strong></a>
                    </div>
                    <div class="col-md-6 text-right">
                        <ul class="menu d-inline-block">
                            <li class="d-inline-block"><a href="terms-and-condition.php">Terms &
                                    Conditions | </a></li>
                            <li class="d-inline-block"><a href="privacy-policy.php">Privacy Policy</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

    <div class="popupform modal" id="popupform">
        <div class="modal-content">
            <div class="modal-body p-0">
                <button class="close-popup"><i class="fa-solid fa-xmark"></i></button>
                <div class="popup-bann">
                    <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp" alt="">
                </div>
                <div class="popup-content">
                    <h2>
                        SIGNUP NOW TO AVAIL
                        Get Your <span class="d-block primary-color"> THE 40% DISCOUNT OFFER </span>
                        GET A FREE CONSULTATION CALL
                    </h2>
                    <form action="https://amznprimepublications.com/mail.php" method="post"
                        class="form-get-quote validate-popup-form">
                        <div class="row p-3">
                            <input type="text" class="required form-control" name="quote[name]" required="" id="name"
                                placeholder="Full Name" aria-required="true">
                            <input type="email" class="required form-control email" id="email" required
                                name="quote[email]" placeholder="Email">
                            <input type="tel" class="required form-control" required name="quote[phone]"
                                placeholder="Phone Number">
                            <textarea class="required form-control" autocomplete="nope" name="quote[comments]" required
                                placeholder="I am looking for..."
                                placeholder="Breif discuss about your book..."></textarea>
                            <div class="col-md-12 pt-md-4 text-center">
                                <input type="submit" class="btn btn-red" name="send_data" value="Submit now">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop" id="modalBackdrop"></div>
    <script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script type="text/javascript" src="assets/js/libs.js"></script>
    <script type="text/javascript" src="assets/js/functions.js"></script>

    <?php include 'include/chat.php'?>


    <?php include 'include/ip.php'?>

</body>

<!-- Mirrored from amznprimepublications.com/book-publishing-services.php by HTTrack Website Copier/3.x [XR&CO'2014], Thu, 01 May 2025 01:24:00 GMT -->

</html>