<!doctype html>
<html lang="en">
<head>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Custom Files -->
<link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
<link rel="stylesheet" type="text/css" href="assets/css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"/>
<link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">

<meta name="ip2loc" content="2400:adc1:4ac:3300:7884:68ef:c6f0:ccee">
<title>Terms of Service | Amzn Prime Publications</title>
<meta name="keywords" content="Amzn Prime Publications, Terms of Service, Book Publishing">
<meta name="description" content="The Terms of Service governing your use of amznprimepublications.com and our services, including acceptable use, payments, messaging, and legal terms.">
</head>

<body>
<?php include 'include/header.php'?>

<!-- Banner -->
<section class="banner main-banner inner-banner privacy text-center"> 
  <div class="container-fluid px-md-5" data-aos="fade-up" data-aos-duration="1000">
    <div class="row align-items-center">
      <div class="col-md-12" data-aos="fade-left" data-aos-duration="1100">
        <div class="inner-pic">
          <h1 class="text-white">Terms of <span class="primary-color d-inline-block">Service</span></h1>
          <p class="text-white py-3">
            By accessing our website or using our services, you agree to these Terms. Please read them carefully.
          </p>
          <a href="tel:+15043538316" class="btn btn-red px-md-4">Request A Call Back <i class="fas fa-phone right-icon"></i></a>
          <a href="javascript:" id="chat_toggle" class="btn btn-blue">Live Chat <i class="fas fa-comments"></i></a>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Terms -->
<section class="book1 terms">
  <div class="container" data-aos="fade-down" data-aos-duration="1000">
    <h2 class="text-center">Terms of Service</h2>
    <p class="text-center mb-5"><strong>Effective Date:</strong> September 11, 2025</p>

    <div class="row align-items-center">
      <div class="col-md-12">

        <h3>1. Acceptance of Terms</h3>
        <p>
          These Terms of Service (“<strong>Terms</strong>”) govern your access to and use of the websites, forms, chat, and services provided by
          <strong>Amzn Prime Publications</strong> (“<strong>Company</strong>,” “<strong>we</strong>,” “<strong>us</strong>,” or “<strong>our</strong>”). By accessing or using our site or services, you agree to be bound by these Terms and our
          <a href="privacy-policy.php">Privacy Policy</a>. If you do not agree, please do not use our services.
        </p>

        <h3>2. Who We Are (Independence Notice)</h3>
        <p>
          Amzn Prime Publications is an independent entity. We are not affiliated, associated, endorsed, or sponsored by Amazon, Inc. or its subsidiaries.
        </p>

        <h3>3. Services & Scope</h3>
        <p>
          We provide custom publishing and creative services, which may include ghostwriting, editing, design/illustration, book formatting, marketing, ad management, website/author site development, audiobook production, and printing coordination. Deliverables, timelines, and pricing will be set out in your order, invoice, or statement of work.
        </p>

        <h3>4. Account, Accuracy & Cooperation</h3>
        <p>
          You agree to provide accurate information and to cooperate with our team (including timely feedback and approvals). Delays in your feedback can affect timelines.
        </p>

        <h3>5. Payments, Billing & Taxes</h3>
        <ul>
          <li>Payment terms will be stated on your invoice/order. Up-front deposits secure scheduling and discovery.</li>
          <li>Payments may be processed through our merchant or payment partners and can appear under their descriptor (e.g., Elite Book LLC).</li>
          <li>You are responsible for any applicable taxes, processor fees, ad spends, printing costs, or other third-party expenses.</li>
        </ul>

        <h3>6. Cancellations & Refunds</h3>
        <p>
          Our <a href="refund-policy.php">Refund Policy</a> explains eligibility, timelines, and how to request a refund. Because services are custom, refunds are limited once work begins. Please review the policy before purchasing.
        </p>

        <h3>7. Messaging Program (SMS & Email)</h3>
        <ul>
          <li><strong>Opt-In:</strong> By providing your phone/email and selecting to receive communications, you consent to messages about services, updates, and—where you consent—promotions. SMS programs may require a confirmatory keyword (e.g., “YES”).</li>
          <li><strong>Frequency & Charges:</strong> Message frequency varies by interaction. Standard carrier message/data rates may apply.</li>
          <li><strong>Opt-Out/Help:</strong> Reply <strong>STOP</strong> to any SMS to unsubscribe; reply <strong>HELP</strong> for help. For email, use the “unsubscribe” link or email <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a>.</li>
          <li><strong>Compliance:</strong> We follow applicable 10DLC/The Campaign Registry rules for US/Canada messaging. Details are in our <a href="privacy-policy.php">Privacy Policy</a> and <a href="opt-out.php">Opt-Out Options</a>.</li>
        </ul>

        <h3>8. Acceptable Use</h3>
        <p>
          You will not misuse the site or services, including by: (a) violating any law; (b) infringing IP or privacy rights; (c) uploading malicious code; (d) attempting to gain unauthorized access; (e) using our deliverables for unlawful, defamatory, or deceptive purposes; or (f) submitting content that is illegal, harmful, or abusive. We may suspend or terminate access for violations.
        </p>

        <h3>9. Your Content & Permissions</h3>
        <p>
          You represent that you have the rights to any content/materials you provide to us and grant us a limited license to use them solely to perform the services and deliver agreed work. You remain responsible for the content you supply.
        </p>

        <h3>10. Intellectual Property & License to Deliverables</h3>
        <ul>
          <li><strong>Final Deliverables:</strong> Upon full payment and subject to any third-party restrictions, we grant you rights to the final, approved deliverables as specified in your order or agreement.</li>
          <li><strong>Work-in-Progress:</strong> Drafts, templates, working files, and internal tools remain our property unless otherwise agreed in writing.</li>
          <li><strong>Trademarks:</strong> Our names, logos, and marks may not be used without our prior written consent.</li>
        </ul>

        <h3>11. Third-Party Tools, Platforms & Ads</h3>
        <p>
          We may use third-party platforms (e.g., analytics, ad networks, hosting, printing, payment processors). Their services are subject to their own terms and policies. We are not responsible for third-party outages or changes. Advertising/remarketing practices are described in the <a href="privacy-policy.php">Privacy Policy</a>.
        </p>

        <h3>12. Disclaimers</h3>
        <p>
          EXCEPT AS EXPRESSLY STATED IN WRITING, THE SITE AND SERVICES ARE PROVIDED “AS IS” AND “AS AVAILABLE” WITHOUT WARRANTIES OF ANY KIND, WHETHER EXPRESS, IMPLIED, OR STATUTORY, INCLUDING WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND NON-INFRINGEMENT. WE DO NOT GUARANTEE ANY SPECIFIC SALES, RANKINGS, OR COMMERCIAL OUTCOMES.
        </p>

        <h3>13. Limitation of Liability</h3>
        <p>
          TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT WILL WE BE LIABLE FOR INDIRECT, INCIDENTAL, SPECIAL, CONSEQUENTIAL, EXEMPLARY, OR PUNITIVE DAMAGES, OR FOR LOST PROFITS/REVENUE/GOODWILL, EVEN IF ADVISED OF THE POSSIBILITY. OUR TOTAL LIABILITY FOR ANY CLAIMS ARISING OUT OF OR RELATED TO THE SERVICES SHALL NOT EXCEED THE AMOUNTS YOU PAID FOR THE SPECIFIC SERVICE GIVING RISE TO THE CLAIM IN THE 3 MONTHS PRECEDING THE EVENT.
        </p>

        <h3>14. Indemnification</h3>
        <p>
          You agree to defend, indemnify, and hold harmless the Company and its personnel from any claims, damages, liabilities, and expenses arising out of (a) your content or instructions; (b) your breach of these Terms; or (c) your violation of any law or third-party right.
        </p>

        <h3>15. Privacy</h3>
        <p>
          Our <a href="privacy-policy.php">Privacy Policy</a> explains how we collect, use, disclose, and protect information, including cookies, analytics, and advertising options (with opt-out links).
        </p>

        <h3>16. Governing Law & Dispute Resolution</h3>
        <p>
          These Terms are governed by the laws of the State of Louisiana, USA (without regard to conflict-of-laws principles). Before pursuing formal action, both parties will first attempt in good faith to resolve disputes through informal negotiations for at least 30 days after written notice. If not resolved, disputes will be brought in the state or federal courts located in Orleans Parish, Louisiana, and the parties consent to jurisdiction and venue there. You and we waive any right to a jury trial to the extent permitted by law.
        </p>

        <h3>17. Changes to These Terms</h3>
        <p>
          We may update these Terms from time to time. Changes take effect upon posting with the updated effective date above. Your continued use of the site/services means you accept the updated Terms.
        </p>

        <h3>18. Contact</h3>
        <p>
          Email: <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a><br>
          Support & Billing: <a href="mailto:support@amznprimepublications.com">support@amznprimepublications.com</a><br>
          Phone: <a href="tel:+15043538316">(504) 353-8316</a>
        </p>

      </div>
    </div>
  </div>
</section>

<!-- Bottom Form -->
<section class="bottom-form">
  <div class="container" data-aos="zoom-in" data-aos-duration="1200">
    <div class="row">
      <div class="col-md-12">
        <div class="get-started-form main-form">
          <form action="https://amznprimepublications.com/mail.php" method="post" class="validate-bottom-form form-get-quote">
            <h6 class="text-white text-center">Feel Free to request now</h6>
            <h2 class="text-center text-white pb-3">Make an Appointment</h2>

            <input type="text" class="required input-control form-control" name="quote[name]" required id="name" placeholder="Full Name" />
            <input type="email" class="required input-control form-control email" id="emailTwo" required name="quote[email]" placeholder="Email">
            <input type="tel" class="required input-control form-control" name="quote[phone]" required placeholder="Phone Number">

            <select name="quote[services]" id="ser-select" class="required input-control form-control d-inline-block">
              <option selected>Select Services</option>
              <option value="Digital Book Publishing">Digital Book Publishing</option>
              <option value="Book Marketing Service">Book Marketing Service</option>
              <option value="Ghostwriting Service">Ghostwriting Service</option>
              <option value="Fiction Writing Service">Fiction Writing Service</option>
              <option value="Children’s Books Service">Children’s Books Service</option>
              <option value="Book Editing & Proofreading Service">Book Editing & Proofreading Service</option>
              <option value="Book Cover Designing">Book Cover Designing</option>
              <option value="Illustrations & Graphics Service">Illustrations & Graphics Service</option>
              <option value="Book Printing Service">Book Printing Service</option>
              <option value="Audiobook Production">Audiobook Production</option>
              <option value="Author Website Service">Author Website Service</option>
              <option value="Blurb Writing Service">Blurb Writing Service</option>
              <option value="Amazon Book Description">Amazon Book Description</option>
              <option value="Amazon Book Listing Optimization">Amazon Book Listing Optimization</option>
              <option value="Amazon Book Paid Ads">Amazon Book Paid Ads</option>
              <option value="Amazon Central Account">Amazon Central Account</option>
              <option value="Amazon A + Content">Amazon A + Content</option>
              <option value="Book Trailer">Book Trailer</option>
              <option value="Featured Articles">Featured Articles</option>
            </select>

            <textarea class="required input-control form-control" autocomplete="nope" name="quote[comments]" placeholder="About Project"></textarea>

            <div class="pt-3 text-center">
              <label class="chota_fnt d-inline-block">
                <input type="checkbox" name="bn_emailPromotional" required checked>
                Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                <a href="privacy-policy.php">PRIVACY POLICY</a> &
                <a href="terms-of-service.php">TERMS OF SERVICE</a> )
                — Carrier charges may apply for SMS. Reply STOP to unsubscribe anytime.
              </label>
            </div>

            <input type="hidden" name="pageurl" value="terms-of-service.php">
            <input type="hidden" name="ip2loc_ip" value="" />
            <input type="hidden" name="ip2loc_isp" value="" />
            <input type="hidden" name="ip2loc_org" value="" />
            <input type="hidden" name="ip2loc_country" value="" />
            <input type="hidden" name="ip2loc_region" value="" />
            <input type="hidden" name="ip2loc_city" value="" />

            <div class="text-center">
              <input type="submit" id="register" class="btn btn-red" name="send_data" value="Let's Get Started">
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

<?php include 'include/footer.php'?>

<a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

<!-- Popup -->
<div class="popupform modal" id="popupform">
  <div class="modal-content">
    <div class="modal-body p-0">
      <button class="close-popup"><i class="fa-solid fa-xmark"></i></button>
      <div class="popup-bann">
        <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp" alt="">
      </div>
      <div class="popup-content">
        <h2>
          SIGNUP NOW TO AVAIL
          Get Your <span class="d-block primary-color">40% DISCOUNT OFFER</span>
          GET A FREE CONSULTATION CALL
        </h2>
        <form action="https://amznprimepublications.com/mail.php" method="post" class="form-get-quote validate-popup-form">
          <div class="row p-3">
            <input type="text" class="required form-control" name="quote[name]" required id="name" placeholder="Full Name" aria-required="true">
            <input type="email" class="required form-control email" id="email" required name="quote[email]" placeholder="Email">
            <input type="tel" class="required form-control" required name="quote[phone]" placeholder="Phone Number">
            <textarea class="required form-control" autocomplete="nope" name="quote[comments]" required placeholder="I am looking for..."></textarea>
            <div class="col-md-12 pt-md-4 text-center">
              <input type="submit" class="btn btn-red" name="send_data" value="Submit now">
            </div>
            <input type="hidden" name="pageurl" value="terms-of-service.php">
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<div class="modal-backdrop" id="modalBackdrop"></div>

<script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
<script type="text/javascript" src="assets/js/libs.js"></script>
<script type="text/javascript" src="assets/js/functions.js"></script>

<?php include 'include/chat.php'?>
<?php include 'include/ip.php'?>

</body>
</html>
