<!doctype html>
<html lang="en">

<head>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Custom Files -->
<link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
<link rel="stylesheet" type="text/css" href="assets/css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"/>
<link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">

<meta name="ip2loc" content="2400:adc1:4ac:3300:7884:68ef:c6f0:ccee">
<title>Refund Policy | Amzn Prime Publications</title>
<meta name="keywords" content="Amzn Prime Publications Policy, Book Publication, Refund Policy">
<meta name="description" content="Clear and transparent refund policy for services purchased from amznprimepublications.com, including eligibility, timelines, and how to request a refund.">
</head>

<body>
<?php include 'include/header.php'?>

<!-- Banner -->
<section class="banner main-banner inner-banner">
  <div class="container" data-aos="fade-down" data-aos-duration="1000">
    <div class="row align-items-center">
      <div class="col-md-7" data-aos="fade-in-up" data-aos-duration="1100">
        <h1>Refund <span class="primary-color d-inline-block">Policy</span></h1>
        <p class="py-3 text-white">Please review our refund terms, eligibility, and request process before purchasing.</p>
        <div class="trusted-images">
          <a href="javascript:;" onclick="setButtonURL();" class="btn btn-red">START PROJECT <i class="fas fa-phone right-icon"></i></a>
          <a href="tel:+15043538316" class="btn btn-white-border px-md-3">CALL NOW <i class="fas fa-phone right-icon"></i></a>
        </div>
      </div>

      <!-- Quote Form -->
      <div class="col-md-5">
        <div class="get-started-form main-form">
          <form action="https://amznprimepublications.com/mail.php" method="post" class="validate-letsget form-get-quote">
            <h3 class="text-white pb-3">Get a Free Quote</h3>
            <input type="text" class="required input-control form-control" name="quote[name]" required id="name" placeholder="Full Name" />
            <input type="email" class="required input-control form-control email" id="email" required name="quote[email]" placeholder="Email">
            <input type="tel" class="required input-control form-control" required name="quote[phone]" placeholder="Phone Number">
            <textarea class="required input-control form-control" autocomplete="nope" name="quote[comments]" required placeholder="I am looking for..." style="height:110px;"></textarea>

            <br><br>
            <label class="chota_fnt">
              <input type="checkbox" name="bn_emailPromotional" required checked>
              Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
              <a href="privacy-policy.php">PRIVACY POLICY</a> &
              <a href="terms-and-conditions.php">TERMS &amp; CONDITIONS</a> )
              — Carrier charges may apply for SMS. Reply STOP to unsubscribe anytime.
            </label>

            <div class="py-2">
              <input type="hidden" name="pageurl" value="refund-policy.php">
              <input type="hidden" name="ip2loc_ip" value="" />
              <input type="hidden" name="ip2loc_isp" value="" />
              <input type="hidden" name="ip2loc_org" value="" />
              <input type="hidden" name="ip2loc_country" value="" />
              <input type="hidden" name="ip2loc_region" value="" />
              <input type="hidden" name="ip2loc_city" value="" />
              <input type="submit" id="register" class="btn btn-red" name="send_data" value="Let's Get Started">
            </div>
          </form>
        </div>
      </div>
      <!-- /Quote Form -->
    </div>
  </div>
</section>

<!-- Policy -->
<section class="book1 terms">
  <div class="container" data-aos="fade-down" data-aos-duration="1000">
    <h2 class="text-center">Refund Policy</h2>
    <p class="text-center"><strong>Effective Date:</strong> September 11, 2025</p>

    <div class="row align-items-center">
      <div class="col-md-12">

        <h3>1) Overview</h3>
        <p>
          We aim to deliver transparent, high-quality publishing and creative services. Because most of our work is custom and begins shortly after payment, refunds are limited and evaluated fairly against the criteria below.
        </p>

        <h3>2) Non-Refundable Services (After Work Starts)</h3>
        <p>
          The following become non-refundable once scoping is approved and work has commenced: ghostwriting, editing/proofreading, design/illustration, book formatting, marketing campaigns, paid ad management, web/author site development, printing coordination, audiobook production, and other bespoke deliverables.
        </p>

        <h3>3) When You <em>May</em> Be Eligible</h3>
        <ul>
          <li><strong>No Work Started:</strong> If <em>no</em> work has begun and no discovery/consultation has taken place, you may request a full refund within <strong>7 days</strong> of payment.</li>
          <li><strong>Duplicate Payment:</strong> Any accidental duplicate charge will be refunded in full once verified.</li>
          <li><strong>Service Not Delivered Due to Our Error:</strong> If agreed deliverables are not provided within the specified timeframe <em>and</em> we fail to remedy after your written notice and a reasonable cure period (typically 7 business days), a partial or full refund may be considered.</li>
        </ul>

        <h3>4) Deposits &amp; Milestones</h3>
        <p>
          Up-front deposits secure scheduling and discovery. If work has begun, a refund—if approved—will exclude the value of hours, third-party costs (e.g., ads, printing holds), and completed milestones already delivered or in progress.
        </p>

        <h3>5) How to Request a Refund</h3>
        <p>
          Email <a href="mailto:support@amznprimepublications.com">support@amznprimepublications.com</a> with:
        </p>
        <ul>
          <li>Your full name, order/invoice number, and purchase date</li>
          <li>Service purchased and reason for the request</li>
          <li>Any supporting evidence (e.g., duplicate charge screenshot)</li>
        </ul>
        <p>
          We acknowledge refund requests within <strong>2 business days</strong> and provide a resolution within <strong>7–10 business days</strong>. Approved refunds are issued to the original payment method.
        </p>

        <h3>6) Revisions vs. Refunds</h3>
        <p>
          Most concerns can be resolved via revisions as per your service package. Please share specific, written feedback so our team can address gaps quickly and professionally.
        </p>

        <h3>7) Chargebacks &amp; Disputes</h3>
        <p>
          If you have any concerns, please contact us first at <a href="mailto:support@amznprimepublications.com">support@amznprimepublications.com</a>. We’re committed to resolving issues promptly and transparently. Initiating a chargeback before giving us an opportunity to assist may delay resolution.
        </p>

        <h3>8) Taxes, Fees &amp; Third-Party Costs</h3>
        <p>
          Payment processor fees, ad spend, marketplace fees, printing proofs, and other third-party costs already incurred on your behalf are non-refundable.
        </p>

        <h3>9) Contact</h3>
        <p>
          Email: <a href="mailto:support@amznprimepublications.com">support@amznprimepublications.com</a><br>
          Sales &amp; Billing: <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a><br>
          Phone: <a href="tel:+15043538316">(504) 353-8316</a>
        </p>

        <hr class="my-5">

        <h2 class="text-center">Terms &amp; Conditions (Key Points)</h2>
        <div class="row align-items-center">
          <div class="col-md-12">
            <h3>1) Service Commencement</h3>
            <p>Payment authorizes us to begin discovery, scheduling, and production. Scope changes may impact timelines/cost.</p>

            <h3>2) Intellectual Property</h3>
            <p>Final, approved deliverables transfer to you upon full payment. Drafts, templates, and working files remain our property unless otherwise agreed in writing.</p>

            <h3>3) Timelines &amp; Communication</h3>
            <p>Timelines are estimates and depend on timely client feedback and approvals.</p>

            <h3>4) Identity / Disclaimer</h3>
            <p>
              Amzn Prime Publications is an independent entity and is not affiliated, associated, endorsed, or sponsored by Amazon, Inc., or its subsidiaries. This disclaimer is displayed across our materials and website.
            </p>

            <h3>5) Payment Descriptor</h3>
            <p>Payments may be processed through Elite Book LLC and can appear under that name on your statement.</p>
          </div>
        </div>

        <p class="mt-4"><em>We may update this policy from time to time. The most current version will always be posted on this page with the effective date above.</em></p>

      </div>
    </div>
  </div>
</section>

<!-- Bottom Form -->
<section class="bottom-form">
  <div class="container" data-aos="zoom-in" data-aos-duration="1200">
    <div class="row">
      <div class="col-md-12">
        <div class="get-started-form main-form">
          <form action="https://amznprimepublications.com/mail.php" method="post" class="validate-bottom-form form-get-quote">
            <h6 class="text-white text-center">Feel Free to request now</h6>
            <h2 class="text-center text-white pb-3">Make an Appointment</h2>

            <input type="text" class="required input-control form-control" name="quote[name]" required id="name" placeholder="Full Name" />
            <input type="email" class="required input-control form-control email" id="emailTwo" required name="quote[email]" placeholder="Email">
            <input type="tel" class="required input-control form-control" name="quote[phone]" required placeholder="Phone Number">

            <select name="quote[services]" id="ser-select" class="required input-control form-control d-inline-block">
              <option selected>Select Services</option>
              <option value="Digital Book Publishing">Digital Book Publishing</option>
              <option value="Book Marketing Service">Book Marketing Service</option>
              <option value="Ghostwriting Service">Ghostwriting Service</option>
              <option value="Fiction Writing Service">Fiction Writing Service</option>
              <option value="Children’s Books Service">Children’s Books Service</option>
              <option value="Book Editing & Proofreading Service">Book Editing & Proofreading Service</option>
              <option value="Book Cover Designing">Book Cover Designing</option>
              <option value="Illustrations & Graphics Service">Illustrations & Graphics Service</option>
              <option value="Book Printing Service">Book Printing Service</option>
              <option value="Audiobook Production">Audiobook Production</option>
              <option value="Author Website Service">Author Website Service</option>
              <option value="Blurb Writing Service">Blurb Writing Service</option>
              <option value="Amazon Book Description">Amazon Book Description</option>
              <option value="Amazon Book Listing Optimization">Amazon Book Listing Optimization</option>
              <option value="Amazon Book Paid Ads">Amazon Book Paid Ads</option>
              <option value="Amazon Central Account">Amazon Central Account</option>
              <option value="Amazon A + Content">Amazon A + Content</option>
              <option value="Book Trailer">Book Trailer</option>
              <option value="Featured Articles">Featured Articles</option>
            </select>

            <textarea class="required input-control form-control" autocomplete="nope" name="quote[comments]" placeholder="About Project"></textarea>

            <div class="pt-3 text-center">
              <label class="chota_fnt d-inline-block">
                <input type="checkbox" name="bn_emailPromotional" required checked>
                Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                <a href="privacy-policy.php">PRIVACY POLICY</a> &
                <a href="terms-and-conditions.php">TERMS &amp; CONDITIONS</a> )
                — Carrier charges may apply for SMS. Reply STOP to unsubscribe anytime.
              </label>
            </div>

            <input type="hidden" name="pageurl" value="refund-policy.php">
            <input type="hidden" name="ip2loc_ip" value="" />
            <input type="hidden" name="ip2loc_isp" value="" />
            <input type="hidden" name="ip2loc_org" value="" />
            <input type="hidden" name="ip2loc_country" value="" />
            <input type="hidden" name="ip2loc_region" value="" />
            <input type="hidden" name="ip2loc_city" value="" />

            <div class="text-center">
              <input type="submit" id="register" class="btn btn-red" name="send_data" value="Let's Get Started">
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Footer -->
<?php include 'include/footer.php'?>

<a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

<!-- Popup -->
<div class="popupform modal" id="popupform">
  <div class="modal-content">
    <div class="modal-body p-0">
      <button class="close-popup"><i class="fa-solid fa-xmark"></i></button>
      <div class="popup-bann">
        <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp" alt="">
      </div>
      <div class="popup-content">
        <h2>
          SIGN UP NOW TO AVAIL
          Get Your <span class="d-block primary-color">40% DISCOUNT OFFER</span>
          GET A FREE CONSULTATION CALL
        </h2>
        <form action="https://amznprimepublications.com/mail.php" method="post" class="form-get-quote validate-popup-form">
          <div class="row p-3">
            <input type="text" class="required form-control" name="quote[name]" required id="name" placeholder="Full Name" aria-required="true">
            <input type="email" class="required form-control email" id="email" required name="quote[email]" placeholder="Email">
            <input type="tel" class="required form-control" required name="quote[phone]" placeholder="Phone Number">
            <textarea class="required form-control" autocomplete="nope" name="quote[comments]" required placeholder="I am looking for..."></textarea>
            <div class="col-md-12 pt-md-4 text-center">
              <input type="submit" class="btn btn-red" name="send_data" value="Submit now">
            </div>

            <input type="hidden" name="pageurl" value="refund-policy.php">
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<div class="modal-backdrop" id="modalBackdrop"></div>

<script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
<script type="text/javascript" src="assets/js/libs.js"></script>
<script type="text/javascript" src="assets/js/functions.js"></script>

<?php include 'include/chat.php'?>
<?php include 'include/ip.php'?>

</body>
</html>
