<!doctype html>
<html lang="en">
<head>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Custom Files -->
<link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
<link rel="stylesheet" type="text/css" href="assets/css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"/>
<link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">

<meta name="ip2loc" content="2400:adc1:4ac:3300:7884:68ef:c6f0:ccee">
<title>Privacy Policy | Amzn Prime Publications</title>
<meta name="keywords" content="Privacy Policy, Amzn Prime Publications, Data Protection, Book Publishing">
<meta name="description" content="How Amzn Prime Publications collects, uses, discloses, and protects your information, including cookies, analytics, and advertising (remarketing). Manage your choices and opt-out preferences.">
</head>

<body>
<?php include 'include/header.php'?>

<!-- Banner -->
<section class="banner main-banner inner-banner privacy text-center"> 
  <div class="container-fluid px-md-5" data-aos="fade-up" data-aos-duration="1000">
    <div class="row align-items-center">
      <div class="col-md-12" data-aos="fade-left" data-aos-duration="1100">
        <div class="inner-pic">
          <h1 class="text-white">Privacy <span class="primary-color d-inline-block">Policy</span></h1>
          <p class="text-white py-3">
            Your privacy matters. This policy explains what we collect, how we use it, and the choices you have.
          </p>
          <a href="tel:+15043538316" class="btn btn-red px-md-4">Request A Call Back <i class="fas fa-phone right-icon"></i></a>
          <a href="javascript:" id="chat_toggle" class="btn btn-blue">Live Chat <i class="fas fa-comments"></i></a>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Policy -->
<section class="book1 terms">
  <div class="container" data-aos="fade-down" data-aos-duration="1000">
    <h2 class="text-center">Privacy Policy</h2>
    <p class="text-center mb-5"><strong>Effective Date:</strong> September 11, 2025</p>

    <div class="row align-items-start">
      <div class="col-md-12">

        <h3>1. Who We Are</h3>
        <p>
          This Privacy Policy describes how <strong>Amzn Prime Publications</strong> (“we,” “us,” or “our”) collects, uses,
          discloses, and protects your information when you visit our website(s), interact with our forms and live chat,
          subscribe to communications, or use our services. Contact us at
          <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a> or <a href="tel:+15043538316">(504) 353-8316</a>.
        </p>

        <h3>2. Information We Collect</h3>
        <ul>
          <li><strong>Information You Provide:</strong> Name, email, phone, project details, service selections, files you upload, and messages via forms or chat.</li>
          <li><strong>Transactional & Account Data:</strong> Quotes, invoices, receipts, and consultation notes (where applicable).</li>
          <li><strong>Communications Data:</strong> Your consent preferences (SMS/email), and message history with our team.</li>
          <li><strong>Device/Usage Data:</strong> IP address, browser/device type, pages viewed, referring URLs, session duration, clickstream.</li>
          <li><strong>Cookies & Similar Tech:</strong> Cookies, pixels, tags (see “Cookies, Analytics & Advertising”).</li>
          <li><strong>Approximate Location:</strong> Derived from IP for security/fraud prevention and localization (e.g., time zone).</li>
        </ul>

        <h3>3. How We Use Your Information</h3>
        <ul>
          <li>To provide, operate, and improve our website and services.</li>
          <li>To respond to inquiries, schedule calls, and deliver requested work.</li>
          <li>To send service updates and transactional notices and—<em>with your consent</em>—marketing via SMS or email.</li>
          <li>To personalize content, measure performance, and enhance user experience.</li>
          <li>To protect against fraud and abuse and maintain system security.</li>
          <li>To comply with legal obligations and enforce our <a href="terms-and-conditions.php">Terms &amp; Conditions</a>.</li>
        </ul>

        <h3>4. Legal Bases (GDPR/UK GDPR)</h3>
        <p>Where EU/UK laws apply, we process data under these legal bases:</p>
        <ul>
          <li><strong>Contractual Necessity</strong> (deliver requested services).</li>
          <li><strong>Consent</strong> (optional marketing, cookies, certain analytics/advertising).</li>
          <li><strong>Legitimate Interests</strong> (site functionality, service improvement, security).</li>
          <li><strong>Legal Obligation</strong> (record-keeping, lawful requests).</li>
        </ul>

        <h3>5. SMS &amp; Email Communications (10DLC/TCR)</h3>
        <ul>
          <li><strong>Opt-In:</strong> By providing your phone/email and opting in, you consent to receive messages. SMS programs may request a confirmatory keyword (e.g., “YES”).</li>
          <li><strong>Frequency:</strong> Varies by interaction and service needs.</li>
          <li><strong>Opt-Out:</strong> Reply <strong>STOP</strong> to any SMS; use the email “unsubscribe” link or email <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a>.</li>
          <li><strong>Rates:</strong> Standard carrier message/data rates may apply.</li>
          <li><strong>Program Rules:</strong> We follow The Campaign Registry (TCR) 10DLC requirements where applicable.</li>
        </ul>

        <h3>6. Cookies, Analytics &amp; Advertising (Important for Google Ads)</h3>
        <p>
          We and our partners use cookies and similar technologies to operate the site, remember preferences, perform analytics,
          and support advertising (including <strong>remarketing</strong>/<strong>retargeting</strong>). These may set or read cookies and collect usage
          data across sites over time to show ads that are more relevant to you. We do <em>not</em> sell personal information.
        </p>
        <ul>
          <li><strong>Analytics:</strong> We may use tools (e.g., Google Analytics) that collect pseudonymous usage data. You can opt out with the
            <a href="https://tools.google.com/dlpage/gaoptout" target="_blank" rel="nofollow noopener">Google Analytics Opt-out Add-on</a>.
          </li>
          <li><strong>Advertising & Remarketing:</strong> We may use Google Ads and similar platforms to show ads to website visitors on other sites/apps.
            You can manage ad personalization via
            <a href="https://adssettings.google.com" target="_blank" rel="nofollow noopener">Google Ad Settings</a>,
            or opt out via the
            <a href="https://optout.networkadvertising.org/" target="_blank" rel="nofollow noopener">NAI</a>,
            <a href="https://optout.aboutads.info/" target="_blank" rel="nofollow noopener">DAA</a>,
            and (EU/UK/EEA) <a href="https://www.youronlinechoices.eu/" target="_blank" rel="nofollow noopener">EDAA</a> tools.
          </li>
          <li><strong>Browser Controls:</strong> You can adjust your browser to refuse some or all cookies; disabling cookies may affect site functionality.</li>
        </ul>
        <p>
          <strong>EEA/UK Consent:</strong> Where required by law, we request your consent for non-essential cookies via a consent banner/CMP. You can update your choices anytime through the banner link (where shown) or by visiting our
          <a href="opt-out.php">Opt-Out Options</a> page.
        </p>
        <p><strong>Sensitive Categories:</strong> We do not create interest categories based on sensitive information (e.g., health, political beliefs, sexual orientation).</p>

        <h3>7. How We Share Information</h3>
        <ul>
          <li><strong>Service Providers:</strong> Hosting, analytics, email/SMS delivery, form processing, payment/invoicing (if used). They act on our instructions.</li>
          <li><strong>Business Transfers:</strong> In a merger, acquisition, or asset sale, data may transfer as permitted by law.</li>
          <li><strong>Legal &amp; Safety:</strong> To comply with law, enforce terms, or protect rights, property, users, or the public.</li>
        </ul>

        <h3>8. Data Retention</h3>
        <p>
          We retain personal data only as long as necessary for the purposes described—generally for the duration of services and a reasonable period thereafter for records, accounting, legal compliance, and dispute resolution.
        </p>

        <h3>9. Security</h3>
        <p>We implement administrative, technical, and physical safeguards to protect personal data. No method is 100% secure.</p>

        <h3>10. International Data Transfers</h3>
        <p>
          Your information may be processed in jurisdictions with different data protection laws. Where required, we use appropriate safeguards (e.g., Standard Contractual Clauses).
        </p>

        <h3>11. Your Rights &amp; Choices</h3>
        <p>Depending on your location, you may have the right to:</p>
        <ul>
          <li>Access, correct, or delete your personal information.</li>
          <li>Object to or restrict processing, or withdraw consent (without affecting prior lawful processing).</li>
          <li>Data portability (receive a copy of your data in a usable format).</li>
          <li>Opt out of marketing (SMS <strong>STOP</strong> / email unsubscribe).</li>
          <li>Manage cookies and advertising choices (see Section 6) or visit our <a href="opt-out.php">Opt-Out Options</a> page.</li>
        </ul>
        <p>To exercise rights, contact: <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a>.</p>

        <h3>12. CCPA/CPRA (California)</h3>
        <p>
          California residents may request to know, access, correct, or delete personal information and opt out of certain data “sharing” (for cross-context behavioral advertising). We do not “sell” personal information as defined by CPRA.
          If we engage in “sharing” for advertising, you can opt out via cookie settings or our <a href="opt-out.php">Opt-Out Options</a> page. We will not discriminate against you for exercising your rights.
        </p>
        <p><a href="opt-out.php" class="btn btn-blue px-md-3">Do Not Sell or Share My Personal Information</a></p>

        <h3>13. Children’s Privacy</h3>
        <p>
          Our services are not directed to children under 13 (or relevant local age). We do not knowingly collect children’s personal data. If you believe a child has provided personal data, contact us to request deletion.
        </p>

        <h3>14. Do Not Track</h3>
        <p>
          Because there is no common industry standard, we may not respond to DNT signals. You can manage tracking via cookie settings and browser controls.
        </p>

        <h3>15. Links to Other Websites</h3>
        <p>Our site may link to third-party sites. We are not responsible for their privacy practices. Review their policies before providing data.</p>

        <h3>16. Changes to This Policy</h3>
        <p>
          We may update this Privacy Policy from time to time. Changes take effect upon posting with the updated effective date. Material changes will be highlighted or communicated when appropriate. Your continued use means you accept the updated Policy.
        </p>

        <h3>17. Contact Us</h3>
        <p>
          Email: <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a><br>
          Phone: <a href="tel:+15043538316">(504) 353-8316</a><br>
          Mailing inquiries available upon request.
        </p>

      </div>
    </div>
  </div>
</section>

<!-- Bottom Form -->
<section class="bottom-form">
  <div class="container" data-aos="zoom-in" data-aos-duration="1200">
    <div class="row">
      <div class="col-md-12">
        <div class="get-started-form main-form">
          <form action="https://amznprimepublications.com/mail.php" method="post" class="validate-bottom-form form-get-quote">
            <h6 class="text-white text-center">Feel Free to request now</h6>
            <h2 class="text-center text-white pb-3">Make an Appointment</h2>

            <input type="text" class="required input-control form-control" name="quote[name]" required id="name" placeholder="Full Name" />
            <input type="email" class="required input-control form-control email" id="emailTwo" required name="quote[email]" placeholder="Email">
            <input type="tel" class="required input-control form-control" name="quote[phone]" required placeholder="Phone Number">

            <select name="quote[services]" id="ser-select" class="required input-control form-control d-inline-block">
              <option selected>Select Services</option>
              <option value="Digital Book Publishing">Digital Book Publishing</option>
              <option value="Book Marketing Service">Book Marketing Service</option>
              <option value="Ghostwriting Service">Ghostwriting Service</option>
              <option value="Fiction Writing Service">Fiction Writing Service</option>
              <option value="Children’s Books Service">Children’s Books Service</option>
              <option value="Book Editing & Proofreading Service">Book Editing & Proofreading Service</option>
              <option value="Book Cover Designing">Book Cover Designing</option>
              <option value="Illustrations & Graphics Service">Illustrations & Graphics Service</option>
              <option value="Book Printing Service">Book Printing Service</option>
              <option value="Audiobook Production">Audiobook Production</option>
              <option value="Author Website Service">Author Website Service</option>
              <option value="Blurb Writing Service">Blurb Writing Service</option>
              <option value="Amazon Book Description">Amazon Book Description</option>
              <option value="Amazon Book Listing Optimization">Amazon Book Listing Optimization</option>
              <option value="Amazon Book Paid Ads">Amazon Book Paid Ads</option>
              <option value="Amazon Central Account">Amazon Central Account</option>
              <option value="Amazon A + Content">Amazon A + Content</option>
              <option value="Book Trailer">Book Trailer</option>
              <option value="Featured Articles">Featured Articles</option>
            </select>

            <textarea class="required input-control form-control" autocomplete="nope" name="quote[comments]" placeholder="About Project"></textarea>

            <div class="pt-3 text-center">
              <label class="chota_fnt d-inline-block">
                <input type="checkbox" name="bn_emailPromotional" required checked>
                Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                <a href="privacy-policy.php">PRIVACY POLICY</a>
                &amp; <a href="terms-and-conditions.php">TERMS &amp; CONDITIONS</a> )
                — Carrier charges may apply for SMS. Reply STOP to unsubscribe anytime.
              </label>
            </div>

            <input type="hidden" name="pageurl" value="privacy-policy.php">
            <input type="hidden" name="ip2loc_ip" value="" />
            <input type="hidden" name="ip2loc_isp" value="" />
            <input type="hidden" name="ip2loc_org" value="" />
            <input type="hidden" name="ip2loc_country" value="" />
            <input type="hidden" name="ip2loc_region" value="" />
            <input type="hidden" name="ip2loc_city" value="" />

            <div class="text-center">
              <input type="submit" id="register" class="btn btn-red" name="send_data" value="Let's Get Started">
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

<?php include 'include/footer.php'?>

<a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

<!-- Popup -->
<div class="popupform modal" id="popupform">
  <div class="modal-content">
    <div class="modal-body p-0">
      <button class="close-popup"><i class="fa-solid fa-xmark"></i></button>
      <div class="popup-bann">
        <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp" alt="">
      </div>
      <div class="popup-content">
        <h2>
          SIGNUP NOW TO AVAIL
          Get Your <span class="d-block primary-color">40% DISCOUNT OFFER</span>
          GET A FREE CONSULTATION CALL
        </h2>
        <form action="https://amznprimepublications.com/mail.php" method="post" class="form-get-quote validate-popup-form">
          <div class="row p-3">
            <input type="text" class="required form-control" name="quote[name]" required id="name" placeholder="Full Name" aria-required="true">
            <input type="email" class="required form-control email" id="email" required name="quote[email]" placeholder="Email">
            <input type="tel" class="required form-control" required name="quote[phone]" placeholder="Phone Number">
            <textarea class="required form-control" autocomplete="nope" name="quote[comments]" required placeholder="I am looking for..."></textarea>
            <div class="col-md-12 pt-md-4 text-center">
              <input type="submit" class="btn btn-red" name="send_data" value="Submit now">
            </div>
            <input type="hidden" name="pageurl" value="privacy-policy.php">
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<div class="modal-backdrop" id="modalBackdrop"></div>

<script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
<script type="text/javascript" src="assets/js/libs.js"></script>
<script type="text/javascript" src="assets/js/functions.js"></script>

<?php include 'include/chat.php'?>
<?php include 'include/ip.php'?>

</body>
</html>
