<!doctype html>
<html lang="en">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>  
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<!-- Custom Files -->
<link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
<link rel="stylesheet" type="text/css" href="assets/css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"/>
<link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">



    
        <meta name="ip2loc" content="2400:adc1:4ac:3300:7884:68ef:c6f0:ccee">
    <title>Portfolio Amzn Prime Publications | Expert Book Services</title>
    <meta name="description"
        content="Discover Amzn Prime Publications: Your go-to for book writing, editing, design, and marketing. Learn Portfolio our mission and services today!">
    <meta name="keywords" content=" Amzn Prime Publications, Book Marketing, Book Publication">
</head>

<body data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">
<?php include 'include/header.php'?>
   <section class="banner main-banner inner-banner">
        <div class="container" data-aos="fade-down" data-aos-duration="1000">
            <div class="row align-items-center">
                <div class="col-md-6" data-aos="fade-in-up" data-aos-duration="1100">
                    <h1>Explore Our Success Stories In Amzn Prime Publications </h1>
                    <p class="text-white py-3">
                        Amzn Prime Publications is extremely proud of its authors' accomplishments. From gripping fiction to
                        provocative nonfiction and everything in between, our portfolio includes a wide variety of books
                        that we have assisted in bringing to life. Every product reflects a distinct path through the
                        publishing process, demonstrating our dedication to excellence, originality, and tailored
                        support. See how we've assisted writers like you in turning their ideas into reality by reading
                        the stories that have had an impact.
                    </p>
                    <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                            class="fas fa-phone right-icon"></i></a>
                    <a href="javascript:" id="chat_toggle" class="btn btn-blue" >Live Chat <i
                            class="fas fa-comments"></i></a>
                </div>
                <div class="col-md-6">
                    <div class="get-started-form" data-aos="fade-down" data-aos-duration="1200">
                    <!-- Form Start-->
<div class="get-started-form main-form">
    <form action="https://amznprimepublications.com/mail.php" method="post" class="validate-letsget form-get-quote">
        <h3 class="text-white pb-3">Get a Free Quote</h3>
        <input type="text" class="required input-control form-control" name="quote[name]" required id="name" placeholder="Full Name" />
        <input type="email" class="required input-control form-control email" id="email" required name="quote[email]" placeholder="Email">
        <input type="tel" class="required input-control form-control" required name="quote[phone]"
            placeholder="Phone Number">
        <textarea class="required input-control form-control" autocomplete="nope" name="quote[comments]" required
            placeholder="I am looking for..." style="height:110px;"></textarea>
            <br>
            <br>
        <label class="chota_fnt"><input type="checkbox" name="bn_emailPromotional" required="" checked>
            Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
            <a href="privacy-policy.php">PRIVACY POLICY </a>
            & <a href="terms-and-conditions.php">TERM & CONDITIONS</a> )
            - Carrier charges may apply for SMS. Reply STOP or UNSUBSCRIBE to STOP to unsubscribe anytime. .
        </label>
        <div class="py-2">
            
            <input type="hidden" name="pageurl" value="portfolio.php">
            <input type="hidden" name="ip2loc_ip" value="" />
            <input type="hidden" name="ip2loc_isp" value="" />
            <input type="hidden" name="ip2loc_org" value="" />
            <input type="hidden" name="ip2loc_country" value="" />
            <input type="hidden" name="ip2loc_region" value="" />
            <input type="hidden" name="ip2loc_city" value="" />

            <input type="submit" id="register" class="btn btn-red" name="send_data" value="Let's Get Started"> <br />
        </div>
    </form>
</div>                        <!-- Form End -->
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="tailor cont-detail">
        <div class="container py-5">
            <div class="row align-items-center pt-3">
                <div class="col-md-5">
                </div>
                <div class="col-md-7">
                    <div class="box-shade">
                        <h2 data-aos="fade-up" data-aos-duration="1300">Our Track Record
                            of Success</h2>
                        <p class="py-3" data-aos="fade-up" data-aos-duration="1500">Our mission is to empower writers
                            in our collection have attracted the attention of readers worldwide.
                            We've worked with writers to create interesting, motivational, and enjoyable books. Popular
                            works like an engrossing mystery, a romantic romance, and an instructive self-help manual
                            have all been driven by us. Every accomplishment in our portfolio shows how dedicated we are
                            to making sure every book reaches its greatest potential in the cutthroat publishing
                            industry.</p>
                        <a href="tel:+15043538316" class="btn btn-red px-md-4">Call Now <i
                                class="fas fa-phone right-icon"></i></a>
                        <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Portfolio -->
    <section class="porfilio-slider px-md-5" id="portfolio">
        <div class="container">
            <h6 class="title" data-aos="fade-up" data-aos-duration="1500">Explore Our Portfolio</h6>
            <h2 data-aos="fade-up" data-aos-duration="2000">Success Stories from Amzn Prime Publications </h2>
            <p class="py-4 pb-md-5 px-md-5" data-aos="fade-up" data-aos-duration="2500">
                Browse our portfolio to see the diverse range of successful projects we've managed. From bestselling novels
                to groundbreaking ebooks, our portfolio showcases the quality and impact of Amzn Prime Publications . Each
                success story is a testament to our commitment to excellence and our ability to help authors achieve their
                publishing goals.
            </p>
            <div class="row algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p1.jpg"
                                data-src="assets/images/p1.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>The Story of My Life </h3>
                            <h5 class="pt-1">Helen Keller </h5>
                            <p class="py-3">Helen Keller's autobiography, The Story of My Life, details the remarkable and
                                heroic life of one
                                who overcame great adversity. As a well known American author, disability rights
                                advocate,...</p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p2.jpg"
                                data-src="assets/images/p2.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Surviving the Dead Books Series</h3>
                            <h5 class="pt-1">James Cook</h5>
                            <p class="py-3">HEric Riordan was once a wealthy man leading a comfortable, easy life. Until one
                                day his oldest friend, a Marine Corps veteran and a former mercenary, told him how the world
                                was going to end...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p3.jpg"
                                data-src="assets/images/p3.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Artifice (The Art of Deception Book 1)</h3>
                            <h5 class="pt-1">Patrick Gooch</h5>
                            <p class="py-3">'A dangerous heist and unscrupulous thieves: an art thriller is born!' Thomas
                                Waugh It’s all in the art of deception… <br>
                                When Alan Cleverden is left a number of paintings in his grandfather`s will,...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p4.jpg"
                                data-src="assets/images/p4.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>To Date a Man, You Must Understand a Man...</h3>
                            <h5 class="pt-1">Gregg Michaelsen </h5>
                            <p class="py-3">To Date a Man, You Must Understand a Man: The Keys to Catch a Great Guy
                                Finally, The JEWEL and the companion book to compliment...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p5.jpg"
                                data-src="assets/images/p5.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Fuzzy Moon</h3>
                            <h5 class="pt-1">Tobey Laine Daniels</h5>
                            <p class="py-3">Show a child that it's okay to question things - be it their purpose on Earth or
                                why things are the way they are.
                                <br>
                                Fuzzy Moon's heartwarming story, the Wise Owl's positive affirmations,...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <!--<div class="col-md-6 algin-items-center">-->
                <!--    <div class="parent-bk-moc">-->
                <!--        <div class="book-mock">-->
                <!--            <img class="lazy"-->
                <!--                src="assets/images/p6.jpg"-->
                <!--                data-src="assets/images/p6.jpg" alt="Amzn Prime Publications ">-->
                <!--        </div>-->
                <!--        <div class="book-des">-->
                <!--            <h3>A Heaven Party For Grandpa</h3>-->
                <!--            <h5 class="pt-1">Tammi Kaufman</h5>-->
                <!--            <p class="py-3">Tammi Kaufman is thrilled to share her first children's book titled, A Heaven-->
                <!--                Party (For Grandpa) with children and parents alike. After dealing with the death of her-->
                <!--                Grandpa, Grandmother,...-->
                <!--            </p>-->
                <!--            <a href="https://a.co/d/3V40XEe" target="_blank" class="btn btn-blue dark-blue"-->
                <!--                onclick="setButtonURL();">Live Chat<i class="fa-solid fa-arrow-right"></i></a>-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p7.jpg"
                                data-src="assets/images/p7.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Bonsai for Beginners</h3>
                            <h5 class="pt-1">Noelle Glisson</h5>
                            <p class="py-3">The Essential Guide to Learn How to Grow and Take Care of A Bonsai Tree for the
                                First Time. Discover a Step-by-step Process to Make it Healthy@@ Well-groomed and
                                Everlasting...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p8.jpg"
                                data-src="assets/images/p8.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Quality First Investing: A checklist approach...</h3>
                            <h5 class="pt-1">Björn Fahlén</h5>
                            <p class="py-3">This book will help you turn up big winners that can go up 10 or even 100 times
                                and keep you away from losers. It is primarily a practical guidebook to fundamental analysis
                                through in-depth,...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p9.jpg"
                                data-src="assets/images/p9.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>The Right Words: when you need them most</h3>
                            <h5 class="pt-1">Donna Ashworth</h5>
                            <p class="py-3">The third collection of words to live by, from poet and social media wordsmith
                                Donna Ashworth. Jam-packed full of prose to bring comfort, inspiration and joy...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p10.jpg"
                                data-src="assets/images/p10.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Get In The Kitchen Lets Get Cookin’: Volume 1</h3>
                            <h5 class="pt-1">Kaitlyn Buchanan</h5>
                            <p class="py-3">Gathering many different recipes from family & friends, mixed with adding your
                                personal touch to it always makes cooking more enjoyable. These recipes were gathered &
                                cooked with a Kaitlyn twist. ...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p11.jpg"
                                data-src="assets/images/p11.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Meat Illustrated: A Foolproof Guide...</h3>
                            <h5 class="pt-1">America's Test Kitchen</h5>
                            <p class="py-3">TMEAT EATERS, REJOICE: Increase your meat counter confidence with this
                                award-winning meat cookbook that shows you how to cook 72 cuts of meat in 300+
                                kitchen-tested recipes!...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p12.jpg"
                                data-src="assets/images/p12.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>The Raven and the Wolf</h3>
                            <h5 class="pt-1">Morgan Gauthier</h5>
                            <p class="py-3">Tell the Wolves I am Home. <br>
                                Trapped in a prison cell beneath the Black Tower, Salome holds on to the hope that her
                                friends will rescue her before she is tortured and executed for the Gomorrians' pleasure...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p13.jpg"
                                data-src="assets/images/p13.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>My Roommate is a Reaper: Tome One</h3>
                            <h5 class="pt-1">Andrew Peed</h5>
                            <p class="py-3">Waylon Dalton was doing all right, right up until he lost his job. On the advice
                                of a wise elder that works at his favorite restaurant, Waylon decided to get a roommate.
                                Everything turned upside down...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- New more mockups adding to the brand -->
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p14.jpg"
                                data-src="assets/images/p14.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>To The North</h3>
                            <h5 class="pt-1">Bruce W. Perry</h5>
                            <p class="py-3">Many obstacles obstruct the path to his loved ones, however, including floods,
                                desert extremes, as well as his own gnawing guilt and need for personal redemption.
                                <br>
                                Zeke Sanchez, a part Ute, Hispanic Indian who distinguished himself in Iraq and tends toward
                                peyote inspired spiritual journeys...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p15.jpg"
                                data-src="assets/images/p15.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>THE REVOLUTION WILL BE TOKENIZED...</h3>
                            <h5 class="pt-1">Christoph Brueck </h5>
                            <p class="py-3">“Whip-smart, edgy science-fiction” Goodreads 5-Stars Review <br>
                                Blade Runner meets Hunger Games!<br>
                                In a future where the world is completely digitalized a young woman named Cypher is on the
                                run!<br>
                                After stealing the DAEDALUS, a particularly dangerous piece ...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p16.jpg"
                                data-src="assets/images/p16.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Snowy & Zoey In A New World</h3>
                            <h5 class="pt-1">Hilda Youssef</h5>
                            <p class="py-3">Snowy and Zoey are best friends. They go on an adventure to discover how Corona
                                has changed the world. Along the way they meet up with all their animal friends who tell
                                them how the earth has become a prettier place...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p17.jpg"
                                data-src="assets/images/p17.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>We're On Our Way USA (The Tailspin Travelogues)</h3>
                            <h5 class="pt-1">Andy C Wareing</h5>
                            <p class="py-3">Trading tea and crumpets for coffee and donuts — what could possibly go wrong?
                                It’s a dream for many, but have you ever really wondered what it’s like to pick up your
                                entire life and move to another country? Maybe you should pause for a moment and read this
                                funny yet poignant true story first...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p18.jpg"
                                data-src="assets/images/p18.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Sean wants to be Messi: A Children's Book...</h3>
                            <h5 class="pt-1">Tanya Preminger</h5>
                            <p class="py-3">Sean, an imaginative and determined second-grader, dreams of becoming a football
                                superstar like Lionel Messi. But the journey to greatness isn’t easy! Along the way, he
                                faces fears, bullies...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p19.jpg"
                                data-src="assets/images/p19.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>The Book of Enoch: With Commentary </h3>
                            <h5 class="pt-1">Timothy Alberino </h5>
                            <p class="py-3">This beautifully crafted edition of the Book of Enoch was created through the
                                collaborative effort of Timothy Alberino and the Blurry Creatures podcast (Nathan Henry and
                                Luke Rodgers).
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p20.jpg"
                                data-src="assets/images/p20.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>To My Sibling</h3>
                            <h5 class="pt-1">Freya Winters</h5>
                            <p class="py-3">Introducing "To My Sibling,"
                                <br>
                                For the next 100 days, these daily pages offer a dose of love, encouragement, and a reminder
                                of inner strength.
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p21.jpg"
                                data-src="assets/images/p21.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Crystal Ball Inspiration: The Source</h3>
                            <h5 class="pt-1">Stefan Lenz</h5>
                            <p class="py-3">Get the "Creativity Boost" for your Crystal Ball Photography!
                                <br>
                                You are just getting started with glass ball photography and need inspiration for your
                                photos?
                                <br>
                                You already have some experience with this kind of photography and you are looking for new,
                                creative ideas?

                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p22.jpg"
                                data-src="assets/images/p22.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Landscape Photography: Shoot Like a Pro...</h3>
                            <h5 class="pt-1">Robin Whalley</h5>
                            <p class="py-3">Why do professional photographers take better photos?
                                Being a professional landscape photographer doesn’t make you a better photographer than an
                                amateur. All it means is you earn your living using your photography, but with that comes an
                                added pressure...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p23.jpg"
                                data-src="assets/images/p23.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>LEAN MANAGEMENT: ILLUSTRATED ESSENTIALS</h3>
                            <h5 class="pt-1">Bernard Gagnon</h5>
                            <p class="py-3">TO BETTER UNDERSTAND AND APPLY LEAN - AGILE CONCEPTS
                                <br>
                                LEAN Management’s main objective is to create more value for customers by finding ways for
                                employees, suppliers, and customers to work together in a more effective...
                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row py-5 algin-items-center text-left">
                <div class="col-md-6 algin-items-center">
                    <div class="parent-bk-moc">
                        <div class="book-mock">
                            <img class="lazy"
                                src="assets/images/p24.jpg"
                                data-src="assets/images/p24.jpg" alt="Amzn Prime Publications ">
                        </div>
                        <div class="book-des">
                            <h3>Field Theory For The Non-Physicist</h3>
                            <h5 class="pt-1">Ville Hirvonen</h5>
                            <p class="py-3">Field theory – Why should you learn it? What even are fields?
                                <br>
                                Nearly all of foundational physics is a field theory in some form or another -
                                electromagnetism, general relativity, quantum field theory and many more...

                            </p>
                             <a href="javascript:" id="chat_toggle" class="btn btn-blue dark-blue" >Live Chat <i
                                class="fas fa-comments"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Portfolio -->

    <!-- Client testmonial -->
<section class="  " id="testmonial">
    <div class="container" data-aos="fade-up" data-aos-duration="1000">
        <div class="row align-items-center">
            <div class="col-md-12 py-4 text-center">
                <!-- <h6 class="title">Author say it best</h6> -->
                <h2>Hear What Our Happy Authors Are Saying!</h2>
            </div>
        </div>
        <div class="row align-items-center">
            <div class="owl-carousel owl-theme monial">
                <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                    <div class="review-box">
                        <div class="row py-3 align-items-center">
                            <div class="col-md-4 text-center">
                                <img class="lazy" src="assets/images/bcover6.webp" data-src="assets/images/bcover6.webp" alt="Amzn Prime Publications " width="70%">
                            </div>
                            <div class="col-md-8 text-right">
                                <p class="review-para">Working with Amzn Prime Publications was a dream come true! From start to finish, their team was incredibly supportive and knowledgeable. They made the entire publishing process feel seamless, and I'm thrilled with how my book turned out. I couldn’t have asked for a better experience or a more professional team to bring my vision to life!</p>
                                <div class="row">
                                    <div class="col-md-6 text-left">
                                        <div class="author-info">
                                            <h6>Declan Flood</h6>
                                            <p>1 Review</p>
                                        </div>
                                    </div>
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                    <div class="review-box">
                        <div class="row py-3 align-items-center">
                            <div class="col-md-4 text-center">
                                <img class="lazy" src="assets/images/bcover2.webp" data-src="assets/images/bcover2.webp" alt="Amzn Prime Publications " width="70%">
                            </div>
                            <div class="col-md-8 text-right">
                                <p class="review-para">As a first-time author, I was overwhelmed with the idea of publishing my book. The team at Amzn Prime Publications made everything so easy and straightforward. They walked me through each step, offered fantastic advice, and truly cared about my success. My book looks amazing, and I’m already reaching readers all over the world. Highly recommend! </p>
                                <div class="row">
                                    <div class="col-md-6 text-left">
                                        <div class="author-info">
                                            <h6>LP Munro</h6>
                                            <p>1 Review</p>
                                        </div>
                                    </div>
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                    <div class="review-box">
                        <div class="row py-3 align-items-center">
                            <div class="col-md-4 text-center">
                                <img class="lazy" src="assets/images/bcover3.webp" data-src="assets/images/bcover3.webp" alt="Amzn Prime Publications " width="70%">
                            </div>
                            <div class="col-md-8 text-right">
                                <p class="review-para">Amzn Prime Publications was the perfect solution for me. The platform was easy to use, and I loved having creative control while also getting expert support. The whole process was smooth, and my ebook is now available on multiple platforms. I’ve received so much positive feedback from readers, and I owe it all to the fantastic team at Amzn Prime Publications !</p>
                                <div class="row">
                                    <div class="col-md-6 text-left">
                                        <div class="author-info">
                                            <h6>Ladybird Bip</h6>
                                            <p>1 Review</p>
                                        </div>
                                    </div>
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                    <div class="review-box">
                        <div class="row py-3 align-items-center">
                            <div class="col-md-4 text-center">
                                <img class="lazy" src="assets/images/bcover4.webp" data-src="assets/images/bcover4.webp" alt="Amzn Prime Publications " width="70%">
                            </div>
                            <div class="col-md-8 text-right">
                                <p class="review-para">From the moment I signed up with Amzn Prime Publications, I knew I was in good hands. The editors and designers were top-notch, and they helped turn my manuscript into a polished, professional book. The marketing advice was also invaluable, and I've seen my book sales soar since launch. Thank you for making my publishing dreams a reality!</p>
                                <div class="row">
                                    <div class="col-md-6 text-left">
                                        <div class="author-info">
                                            <h6>Penny Faibland</h6>
                                            <p>1 Review</p>
                                        </div>
                                    </div>
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item mx-2 my-3" data-aos="zoom-in-up" data-aos-duration="1200">
                    <div class="review-box">
                        <div class="row py-3 align-items-center">
                            <div class="col-md-4 text-center">
                                <img class="lazy" src="assets/images/bcover5.webp" data-src="assets/images/bcover5.webp" alt="Amzn Prime Publications " width="70%">
                            </div>
                            <div class="col-md-8 text-right">
                                <p class="review-para">Amzn Prime Publications exceeded my expectations in every way. The level of care, attention to detail, and professionalism they provided was outstanding. They handled everything from editing to cover design beautifully, and I felt supported throughout the entire journey. Seeing my book on the Amzn platform is a feeling I can’t describe – it’s just incredible!</p>
                                <div class="row">
                                    <div class="col-md-6 text-left">
                                        <div class="author-info">
                                            <h6>Neal Smith</h6>
                                            <p>1 Review</p>
                                        </div>
                                    </div>
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Client testmonial End -->


    <!-- FAQ Start-->
<section class="faq-sec pb-0">
    <div class="container" data-aos="fade-up" data-aos-duration="1000">
        <div class="row align-items-center">
            <div class="col-md-7 pb-md-5 ">
                <!-- <h6 class="title">Check whether your question is in FAQs</h6> -->
                <h2>Frequently Asked Questions</h2>
                <div id="accordion">
                    <div class="card">
                        <div class="card-header">
                            <a class="collapsed card-link" data-toggle="collapse" href="#collapseOne">Q.1: What types of publishing services does Amzn Prime Publications offer?</a>
                        </div>
                        <div id="collapseOne" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                <p>
                                    Amzn Prime Publications provides a wide range of publishing services, such as conventional publishing, self-publishing, eBook publishing, audiobook production, and print-on-demand. Our services range from manuscript editing and design to marketing and distribution and are tailored to each author's needs.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <a class="collapsed card-link" data-toggle="collapse" href="#collapseTwo">Q.2: How do I start the publishing process with Amzn Prime Publications ?</a>
                        </div>
                        <div id="collapseTwo" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                <p>
                                    Starting with Amzn Prime Publications is simple! To book an initial consultation, please contact us through our website or phone us directly. During this meeting, we will discuss your objectives, analyze your work, and devise a personalized publishing strategy that is consistent with your vision.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <a class="collapsed card-link" data-toggle="collapse" href="#collapseThree">Q.3: What’s the difference between traditional and self-publishing with Amzn Prime Publications ?</a>
                        </div>
                        <div id="collapseThree" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                <p>
                                    Amzn Prime Publications handles the whole process of conventional publishing, from editing and design to marketing and distribution, typically using a royalty-based remuneration model. Self-publishing, on the other hand, allows you to have complete control over the process, allowing you to make all the decisions while we provide assistance and tools to ensure your success.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <a class="collapsed card-link" data-toggle="collapse" href="#collapseFour">Q.4: How does Amzn Prime Publications help authors with book marketing?</a>
                        </div>
                        <div id="collapseFour" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                <p>
                                    Amzn Prime Publications provides strong marketing help to guarantee your book reaches its intended audience. Our services include online and offline promotional techniques, social media marketing, email campaigns, and book placement in our online shop, all of which contribute to increased awareness and sales for your book.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <a class="collapsed card-link" data-toggle="collapse" href="#collapseFive">Q.5: Can I publish both print books and eBooks with Amzn Prime Publications ?</a>
                        </div>
                        <div id="collapseFive" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                <p>
                                    Absolutely! Amzn Prime Publications provides options for both print books and eBooks. Whether you prefer a physical copy for book signings and events or a digital version to reach readers globally, we have the resources and expertise to publish in both formats, ensuring your book is available wherever your readers are.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <a class="collapsed card-link" data-toggle="collapse" href="#collapseSix">Q.6: What kind of royalties can I expect with Amzn Prime Publications ?</a>
                        </div>
                        <div id="collapseSix" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                <p>
                                    Royalties with Amzn Prime Publications differ depending on whether you choose traditional or self-publishing. Self-publishing allows you to earn a substantial proportion of the sale price. We work with you to find the optimum royalty structure for your publishing goals and the services you select.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <a class="collapsed card-link" data-toggle="collapse" href="#collapseSeven">Q.7: Will I retain the rights to my book when publishing with Amzn Prime Publications ?</a>
                        </div>
                        <div id="collapseSeven" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                <p>
                                    Yes, when you choose to self-publish with Amzn Prime Publications , you maintain complete ownership of your work. You have complete control over the product's manufacturing, distribution, and marketing. Traditional publication rights are negotiated using the provisions outlined in your publishing contract.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-5">
                <img src="assets/images/faq.webp" alt="Amzn Prime Publications " width="100%">
            </div>
        </div>
    </div>
</section>
<!-- FAQ End-->

<section class="bottom-form">
    <div class="container" data-aos="zoom-in" data-aos-duration="1200">
        <div class="row">
            <div class="col-md-12">
                <div class="get-started-form main-form">
                    <form action="https://amznprimepublications.com/mail.php" method="post" class="validate-bottom-form form-get-quote">
                        <h6 class="text-white text-center">Feel Free to request now</h6>
                        <h2 class="text-center text-white pb-3">Make an Appointment</h2>
                        <input type="text" class="required input-control form-control" name="quote[name]" required id="name" placeholder="Full Name" />
                        <input type="email" class="required input-control form-control email" id="emailTwo" required name="quote[email]" placeholder="Email">
                        <input type="tel" class="required input-control form-control" name="quote[phone]" required placeholder="Phone Number">
                        <!-- <input type="number" class="required input-control form-control" name="budget"
                            id="budget" placeholder="Budget" /> -->
                        <select name="quote[services]" id="ser-select" class="required input-control form-control d-inline-block">
                            <option selected>Select Services</option>
                            <option value="Digital Book Publishing">Digital Book Publishing</option>
                            <option value="Book Marketing Service">Book Marketing Service</option>
                            <option value="Ghostwriting Service">Ghostwriting Service</option>
                            <option value="Fiction Writing Service">Fiction Writing Service</option>
                            <option value="Children’s Books Service">Children’s Books Service</option>
                            <option value="Book Editing & Proofreading Service">Book Editing & Proofreading Service
                            </option>
                            <option value="Book Cover Designing">Book Cover Designing</option>
                            <option value="Illustrations & Graphics Service">Illustrations & Graphics Service</option>
                            <option value="Book Printing Service">Book Printing Service</option>
                            <option value="Audiobook Production">Audiobook Production</option>
                            <option value="Author Website Service">Author Website Service</option>
                            <option value="Blurb Writing Service">Blurb Writing Service</option>
                            <option value="Amazon Book Description">Amazon Book Description</option>
                            <option value="Amazon Book Listing Optimization">Amazon Book Listing Optimization</option>
                            <option value="Amazon Book Paid Ads">Amazon Book Paid Ads</option>
                            <option value="Amazon Central Account">Amazon Central Account</option>
                            <option value="Amazon A + Content">Amazon A + Content</option>
                            <option value="Book Trailer">Book Trailer</option>
                            <option value="Featured Articles">Featured Articles</option>
                        </select>
                        <textarea class="required input-control form-control" autocomplete="nope" name="quote[comments]" placeholder="About Project"></textarea>
                        <div class="pt-3 text-center">
                            <label class="chota_fnt d-inline-block"><input type="checkbox" name="bn_emailPromotional" required="" checked>
                                Please CHECK THE BOX to COMMUNICATE VIA SMS OR EMAIL (
                                <a href="privacy-policy.php">PRIVACY POLICY </a>
                                & <a href="terms-and-conditions.php">TERM & CONDITIONS</a> )
                                - Carrier charges may apply for SMS. Reply STOP or UNSUBSCRIBE to STOP to unsubscribe anytime.
                                anytime.
                            </label>
                        </div>
                        <input type="hidden" name="pageurl" value="portfolio.php">
                        <input type="hidden" name="ip2loc_ip" value="" />
                        <input type="hidden" name="ip2loc_isp" value="" />
                        <input type="hidden" name="ip2loc_org" value="" />
                        <input type="hidden" name="ip2loc_country" value="" />
                        <input type="hidden" name="ip2loc_region" value="" />
                        <input type="hidden" name="ip2loc_city" value="" />
                        <div class="text-center">
                            <input type="submit" id="register" class="btn btn-red" name="send_data" value="Let's Get Started" onclick="abc()"> <br />
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Footer -->
<?php include 'include/footer.php'?>


<a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

<div class="popupform modal" id="popupform">
    <div class="modal-content">
        <div class="modal-body p-0">
            <button class="close-popup"><i class="fa-solid fa-xmark"></i></button>
            <div class="popup-bann">
                <img class="lazy" src="assets/images/sl5.webp" data-src="assets/images/sl5.webp" alt="">
            </div>
            <div class="popup-content">
                <h2>
                    SIGNUP NOW TO AVAIL
                    Get Your <span class="d-block primary-color"> THE 40% DISCOUNT OFFER </span>
                    GET A FREE CONSULTATION CALL
                </h2>
                <form action="https://amznprimepublications.com/mail.php" method="post" class="form-get-quote validate-popup-form">
                    <div class="row p-3">
                        <input type="text" class="required form-control" name="quote[name]" required="" id="name" placeholder="Full Name" aria-required="true">
                        <input type="email" class="required form-control email" id="email" required name="quote[email]" placeholder="Email">
                        <input type="tel" class="required form-control" required name="quote[phone]" placeholder="Phone Number">
                        <textarea class="required form-control" autocomplete="nope" name="quote[comments]" required placeholder="I am looking for..." placeholder="Breif discuss about your book..."></textarea>
                        <div class="col-md-12 pt-md-4 text-center">
                            <input type="submit" class="btn btn-red" name="send_data" value="Submit now">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="modal-backdrop" id="modalBackdrop"></div>
<script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script type="text/javascript" src="assets/js/libs.js"></script>
<script type="text/javascript" src="assets/js/functions.js"></script>

<?php include 'include/chat.php'?>


<?php include 'include/ip.php'?>
    
</body>

<!-- Mirrored from amznprimepublications.com/portfolio.php by HTTrack Website Copier/3.x [XR&CO'2014], Thu, 01 May 2025 01:24:22 GMT -->
</html>