<!doctype html>
<html lang="en">

<head>
<meta charset="UTF-8">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<link rel="shortcut icon" type="image/x-icon" href="assets/images/logo.png">
<link rel="stylesheet" type="text/css" href="assets/css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"/>
<link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">

<title>Opt-Out Option | Amzn Prime Publications</title>
<meta name="keywords" content="Opt Out, Unsubscribe, Privacy, Amzn Prime Publications">
<meta name="description" content="Opt-out of SMS, email, cookies, or data sharing with Amzn Prime Publications. Manage your communication and privacy preferences here.">
</head>

<body>
<?php include 'include/header.php'?>

<!-- Banner Section -->
<section class="banner main-banner inner-banner privacy text-center"> 
    <div class="container-fluid px-md-5" data-aos="fade-up" data-aos-duration="1000">
        <div class="row align-items-center">
            <div class="col-md-12" data-aos="fade-left" data-aos-duration="1100">
                <div class="inner-pic">
                    <h1 class="text-white">Opt <span class="primary-color d-inline-block">Out Option</span></h1>
                    <p class="text-white py-3">
                        Manage your privacy choices and control how we contact you.
                    </p>
                    <a href="tel:+15043538316" class="btn btn-red px-md-4">Request A Call Back <i class="fas fa-phone right-icon"></i></a>
                    <a href="javascript:" id="chat_toggle" class="btn btn-blue">Live Chat <i class="fas fa-comments"></i></a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Content Section -->
<section class="book1 terms">
    <div class="container" data-aos="fade-down" data-aos-duration="1000">
        <h2 class="text-center">Opt-Out Choices</h2>
        <p class="text-center mb-5"><strong>Effective Date:</strong> September 5, 2025</p>
        <div class="row align-items-start">
            <div class="col-md-12">

                <h3>1. SMS Communications</h3>
                <p>
                    If you no longer wish to receive SMS messages, simply reply <strong>STOP</strong> to any message you receive. 
                    Standard carrier charges may apply. Once unsubscribed, you will no longer receive marketing or promotional SMS, but may still get essential transactional alerts (if applicable).
                </p>

                <h3>2. Email Communications</h3>
                <p>
                    To stop receiving promotional emails, click the “Unsubscribe” link at the bottom of any email we send, or email us directly at 
                    <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a> with the subject line <strong>Unsubscribe</strong>.
                </p>

                <h3>3. Cookies & Online Tracking</h3>
                <p>
                    You may adjust your browser settings to refuse some or all cookies. Disabling cookies may affect the functionality of our site. 
                    You can also manage ad preferences through Google Ads Settings or opt out via the 
                    <a href="https://optout.networkadvertising.org/" target="_blank">NAI Opt-Out Tool</a>.
                </p>

                <h3>4. Analytics & Third-Party Services</h3>
                <p>
                    We may use third-party analytics and advertising services. You may opt out of data collection by visiting their opt-out pages (e.g., 
                    <a href="https://tools.google.com/dlpage/gaoptout" target="_blank">Google Analytics Opt-out</a>).
                </p>

                <h3>5. CCPA/CPRA & GDPR Rights</h3>
                <p>
                    If you are a California resident or located in the EU/UK, you have the right to opt out of certain data sharing, 
                    request deletion of your data, or withdraw consent for processing. To exercise these rights, email us at 
                    <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a>.
                </p>

                <h3>6. Questions or Help</h3>
                <p>
                    If you encounter any issues while opting out, please contact us at 
                    <a href="mailto:info@amznprimepublications.com">info@amznprimepublications.com</a> or call 
                    <a href="tel:+15043538316">(504) 353-8316</a>. We will honor your request promptly.
                </p>

            </div>
        </div>
    </div>
</section>

<?php include 'include/footer.php'?>

<a id="goto-top" class="btn show"><i class="fas fa-arrow-up"></i></a>

<script type="text/javascript" src="assets/js/libs.js"></script>
<script type="text/javascript" src="assets/js/functions.js"></script>

<?php include 'include/chat.php'?>
<?php include 'include/ip.php'?>

</body>
</html>
