<?php
// ---- Sessions (must be first, before any output) ----
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// Keep original referrer once (avoid notice if not present)
if (!isset($_SESSION['origURL'])) {
    $_SESSION['origURL'] = $_SERVER['HTTP_REFERER'] ?? '';
}

// ---- Current URL (protocol-safe) ----
$isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || ($_SERVER['SERVER_PORT'] ?? null) == 443;
$scheme  = $isHttps ? 'https' : 'http';
$host    = $_SERVER['HTTP_HOST'] ?? 'localhost';
$uri     = $_SERVER['REQUEST_URI'] ?? '/';
$actual_link = $scheme . '://' . $host . $uri;

// ---- IP helper ----
function getUserIP(): string
{
    // Cloudflare real IP header
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP']) && filter_var($_SERVER['HTTP_CF_CONNECTING_IP'], FILTER_VALIDATE_IP)) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    }

    // X-Forwarded-For may contain a list: client, proxy1, proxy2...
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $parts = array_map('trim', explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']));
        foreach ($parts as $ip) {
            if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
                return $ip; // first public IP in the chain
            }
        }
        // fall back to the first valid IP even if private
        foreach ($parts as $ip) {
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                return $ip;
            }
        }
    }

    // Fallback to HTTP_CLIENT_IP if present
    if (!empty($_SERVER['HTTP_CLIENT_IP']) && filter_var($_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP)) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }

    // Final fallback
    return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
}

$user_ip = getUserIP();
?>
<!-- safe output -->
<meta name="ip2loc" content="<?php echo htmlspecialchars($user_ip, ENT_QUOTES, 'UTF-8'); ?>">

<head>
    <!-- Start of LiveChat (www.livechat.com) code -->
<script>
    window.__lc = window.__lc || {};
    window.__lc.license = 19180726;
    window.__lc.integration_name = "manual_channels";
    window.__lc.product_name = "livechat";
    ;(function(n,t,c){function i(n){return e._h?e._h.apply(null,n):e._q.push(n)}var e={_q:[],_h:null,_v:"2.0",on:function(){i(["on",c.call(arguments)])},once:function(){i(["once",c.call(arguments)])},off:function(){i(["off",c.call(arguments)])},get:function(){if(!e._h)throw new Error("[LiveChatWidget] You can't use getters before load.");return i(["get",c.call(arguments)])},call:function(){i(["call",c.call(arguments)])},init:function(){var n=t.createElement("script");n.async=!0,n.type="text/javascript",n.src="https://cdn.livechatinc.com/tracking.js",t.head.appendChild(n)}};!n.__lc.asyncInit&&e.init(),n.LiveChatWidget=n.LiveChatWidget||e}(window,document,[].slice))
</script>
<noscript><a href="https://www.livechat.com/chat-with/19180726/" rel="nofollow">Chat with us</a>, powered by <a href="https://www.livechat.com/?welcome" rel="noopener nofollow" target="_blank">LiveChat</a></noscript>
<!-- End of LiveChat code -->


<script>
// Wait until the LiveChat widget is loaded
window.addEventListener("load", function () {
    function initLiveChat() {
        if (typeof LiveChatWidget !== "undefined") {
            
            // Open chat instantly when widget is ready
            LiveChatWidget.on("ready", function () {
                LiveChatWidget.call("maximize");
            });

            // Toggle chat on .btn-dark clicks
            document.querySelectorAll(".btn-dark").forEach(function (btn) {
                btn.addEventListener("click", function () {
                    LiveChatWidget.call("toggle");
                });
            });

            // Open chat immediately when a new message arrives
            LiveChatWidget.on("new_event", function (event) {
                if (event.type === "message") {
                    LiveChatWidget.call("maximize");
                }
            });
        } else {
            // If widget not ready yet, retry after a short delay
            setTimeout(initLiveChat, 200);
        }
    }

    initLiveChat();
});
</script>
    
</head>

<header>
    <section class="top-bar">
        <div class="container-fluid px-md-5">
            <div class="row">
                <div class="col-md-12">
                    <ul class="menu social-icons">
                        <li class="side-bar-one"><a href="tel:+15043538316"><i class="fas fa-phone-alt"></i> (504) 353-8316 &nbsp; &nbsp; &nbsp; </a> </li>
                        <li><a href="mailto:info@amznprimepublications.com"><i class="fas fa-envelope"></i>&nbsp; <span class="__cf_email__" >info@amznprimepublications.com</span></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <section class="nav-bar">
        <div class="container-fluid px-md-5">
            <div class="row align-items-center">
                <div class="col-md-2">
                    <a href="index.php" class="logo">
                        <img src="assets/images/logo.png" title="Amzn  &amp; Publish" alt="Logo" width="100%">
                    </a>
                </div>
                <div class="col-md-10">
                    <div class="mobile-screen">
                        <a href="javascript:" onclick="navOpen()" class="btn" id="list-btn">
                            <i class="fas fa-bars"></i>
                        </a>
                    </div>
                    <a href="javascript:" onclick="navClosed()" class="btn" id="cross">
                        <i class="fas fa-times"></i>
                    </a>
                    <nav class="mobile-view main-menu" id="menu-list">
                        <ul class="menu">
                            <li><a href="index.php">Home</a></li>
                            <!-- Dropdown start -->
                            <li class="nav-item dropdown">
                                <a class="dropdown-toggle" href="javascript:void(0)">Services </a>
                                <div class="dropdown-menu">
                                    <!-- inner Dropdown start -->
                                    <div class="dropdown submenu-list">
                                        <a class="dropdown-item dropdown-toggle" href="book-publishing-services.php">Book Publishing Services</a>
                                        <div class="dropdown-menu-submenu">
                                            <a class="dropdown-item" href="amazon-publishing-services.php">Amazon Publishing Services</a>
                                            <a class="dropdown-item" href="global-publishing-services.php">Global Publishing Services</a>
                                            <a class="dropdown-item" href="kindle-publishing-services.php">Kindle Publishing</a>
                                        </div>
                                    </div>
                                    <!-- inner Dropdown end -->
                                    <!-- inner Dropdown start -->
                                    <div class="dropdown submenu-list">
                                        <a class="dropdown-item dropdown-toggle" href="book-marketing-services.php">Book Marketing Services</a>
                                        <div class="dropdown-menu-submenu">
                                            <a class="dropdown-item" href="digital-marketing-services.php">Digital Marketing</a>
                                            <a class="dropdown-item" href="amazon-book-listing-optimization-services.php">Amazon Book Listing Optimization</a>
                                            <a class="dropdown-item" href="content-marketing-services.php">Content Marketing</a>
                                            <a class="dropdown-item" href="amazon-paid-ads-services.php">Amazon Paid Ads</a>
                                            <a class="dropdown-item" href="amazon-content-services.php">Amazon A+ Content</a>
                                            <a class="dropdown-item" href="featured-article-services.php">Featured Articles</a>
                                            <a class="dropdown-item" href="author-branding-services.php">Author Branding</a>
                                            <a class="dropdown-item" href="audiobook-marketing-services.php">Audiobook Marketing</a>
                                        </div>
                                    </div>
                                    <!-- inner Dropdown end -->
                                    <!-- inner Dropdown start -->
                                    <div class="dropdown submenu-list">
                                        <a class="dropdown-item dropdown-toggle" href="audiobook-services.php">AudioBook Services</a>
                                        <div class="dropdown-menu-submenu">
                                            <a class="dropdown-item" href="audiobook-production-services.php">Audiobook Production</a>
                                            <a class="dropdown-item" href="audiobook-narration-services.php">Audiobook Narration</a>
                                            <a class="dropdown-item" href="audiobook-publishing-services.php">Audiobook Publishing</a>
                                            <a class="dropdown-item" href="audible-publishing-services.php">Audible Publishing</a>
                                            <a class="dropdown-item" href="google-audiobooks-services.php">Google Audiobook Publishing</a>
                                            <a class="dropdown-item" href="itunes-publishing-services.php">Itunes Publishing</a>
                                        </div>
                                    </div>
                                    <div class="dropdown submenu-list">
                                        <a class="dropdown-item dropdown-toggle" href="book-writing-services.php">Book Writing/Ghost Writing</a>
                                        <div class="dropdown-menu-submenu">
                                            <a class="dropdown-item" href="copywriting-services.php">Copy Writing</a>
                                            <a class="dropdown-item" href="academic-writing-services.php">Academic Writing</a>
                                            <a class="dropdown-item" href="blurb-writing-services.php">Blurb Writing</a>
                                            <a class="dropdown-item" href="script-writing-services.php">Script Writing</a>
                                            <a class="dropdown-item" href="fiction-writing-services.php">Fiction Writing</a>
                                        </div>
                                    </div>
                                    <a class="dropdown-item" href="book-illustration-designing-services.php">Book Illustrations & Designs</a>
                                    <a class="dropdown-item" href="book-editing-services.php">Book Editing Services</a>
                                    <a class="dropdown-item" href="author-website-development-services.php">Author Website Development</a>
                                    <a class="dropdown-item" href="book-printing-services.php">Book Printing Services</a>
                                    <a class="dropdown-item" href="author-podcasts-services.php">Author Podcast Services</a>
                                </div>
                            </li>
                            <!-- Dropdown end -->
                            <li><a href="about-us.php">About Us</a></li>
                            <li><a href="portfolio.php">Portfolio</a></li>
                            <li><a href="children-books-services.php">Children Books </a></li>

                            <li><a href="contact-us.php">Contact</a></li>
                            <div class="btn-nav text-right">
                                <li><a class="btn btn-red" href="tel:+15043538316">Call Now <i class="fas fa-phone right-icon"></i></a></li>
                            </div>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </section>
</header>  



